/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.neo4j.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.wildfly.extension.nosql.driver.neo4j.transaction.SessionProxy;

public class DriverProxy
implements InvocationHandler {
    private final Object underlyingDriver;
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final String profileName;
    private final String jndiName;

    public DriverProxy(Object driver, TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String profileName, String jndiName) {
        this.underlyingDriver = driver;
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.profileName = profileName;
        this.jndiName = jndiName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int txstatus;
        if (method.getName().equals("session") && ((txstatus = this.transactionManager.getStatus()) == 0 || txstatus == 1)) {
            Object result = SessionProxy.getSessionFromJTATransaction(this.transactionSynchronizationRegistry, this.profileName);
            if (result != null) {
                return result;
            }
            return SessionProxy.registerSessionWithJTATransaction(method.invoke(this.underlyingDriver, args), this.transactionManager, this.transactionSynchronizationRegistry, this.profileName, this.jndiName);
        }
        Object result = method.invoke(this.underlyingDriver, args);
        return result;
    }
}

