/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.mongodb;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.nosql.common.SubsystemService;

public class MongoSubsystemService
implements Service<SubsystemService>,
SubsystemService {
    private static final ServiceName SERVICENAME = ServiceName.JBOSS.append(new String[]{"mongodbsubsystem"});
    private static final String VENDORKEY = "MongoDB";
    private final Map<String, String> jndiNameToModuleName = new ConcurrentHashMap<String, String>();
    private final Map<String, String> profileNameToModuleName = new ConcurrentHashMap<String, String>();

    public static ServiceName serviceName() {
        return SERVICENAME;
    }

    public void addModuleNameFromJndi(String jndiName, String module) {
        this.jndiNameToModuleName.put(jndiName, module);
    }

    public void removeModuleNameFromJndi(String jndiName) {
        this.jndiNameToModuleName.remove(jndiName);
    }

    public void addModuleNameFromProfile(String profile, String moduleName) {
        this.profileNameToModuleName.put(profile, moduleName);
    }

    public void removeModuleNameFromProfile(String profile) {
        this.profileNameToModuleName.remove(profile);
    }

    public String moduleNameFromJndi(String jndiName) {
        return this.jndiNameToModuleName.get(jndiName);
    }

    public String moduleNameFromProfile(String profileName) {
        return this.profileNameToModuleName.get(profileName);
    }

    public Collection<String> profileNames() {
        return this.profileNameToModuleName.keySet();
    }

    public Collection<String> jndiNames() {
        return this.jndiNameToModuleName.keySet();
    }

    public String vendorKey() {
        return VENDORKEY;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public SubsystemService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

