/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;

public abstract class OChannelBinary
extends OChannel {
    private static final int MAX_LENGTH_DEBUG = 150;
    protected final boolean debug;
    private final int maxChunkSize;
    public DataInputStream in;
    public DataOutputStream out;

    public OChannelBinary(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(iSocket, iConfig);
        this.maxChunkSize = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH) * 1024;
        this.debug = iConfig.getValueAsBoolean(OGlobalConfiguration.NETWORK_BINARY_DEBUG);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Connected", this.socket.getRemoteSocketAddress());
        }
    }

    public byte readByte() throws IOException {
        this.updateMetricReceivedBytes(1);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading byte (1 byte)...", this.socket.getRemoteSocketAddress());
            byte value = this.in.readByte();
            OLogManager.instance().info((Object)this, "%s - Read byte: %d", this.socket.getRemoteSocketAddress(), (int)value);
            return value;
        }
        return this.in.readByte();
    }

    public boolean readBoolean() throws IOException {
        this.updateMetricReceivedBytes(1);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading boolean (1 byte)...", this.socket.getRemoteSocketAddress());
            boolean value = this.in.readBoolean();
            OLogManager.instance().info((Object)this, "%s - Read boolean: %b", this.socket.getRemoteSocketAddress(), value);
            return value;
        }
        return this.in.readBoolean();
    }

    public int readInt() throws IOException {
        this.updateMetricReceivedBytes(4);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading int (4 bytes)...", this.socket.getRemoteSocketAddress());
            int value = this.in.readInt();
            OLogManager.instance().info((Object)this, "%s - Read int: %d", this.socket.getRemoteSocketAddress(), value);
            return value;
        }
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        this.updateMetricReceivedBytes(8);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading long (8 bytes)...", this.socket.getRemoteSocketAddress());
            long value = this.in.readLong();
            OLogManager.instance().info((Object)this, "%s - Read long: %d", this.socket.getRemoteSocketAddress(), value);
            return value;
        }
        return this.in.readLong();
    }

    public short readShort() throws IOException {
        this.updateMetricReceivedBytes(2);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading short (2 bytes)...", this.socket.getRemoteSocketAddress());
            short value = this.in.readShort();
            OLogManager.instance().info((Object)this, "%s - Read short: %d", this.socket.getRemoteSocketAddress(), value);
            return value;
        }
        return this.in.readShort();
    }

    public String readString() throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading string (4+N bytes)...", this.socket.getRemoteSocketAddress());
            int len = this.in.readInt();
            if (len < 0) {
                return null;
            }
            byte[] tmp = new byte[len];
            this.in.readFully(tmp);
            this.updateMetricReceivedBytes(4 + len);
            String value = new String(tmp);
            OLogManager.instance().info((Object)this, "%s - Read string: %s", this.socket.getRemoteSocketAddress(), value);
            return value;
        }
        int len = this.in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        this.updateMetricReceivedBytes(4 + len);
        return new String(tmp);
    }

    public byte[] readBytes() throws IOException {
        int len;
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading chunk of bytes. Reading chunk length as int (4 bytes)...", this.socket.getRemoteSocketAddress());
        }
        if ((len = this.in.readInt()) > this.maxChunkSize) {
            throw OException.wrapException(new OIOException("Impossible to read a chunk of length:" + len + " max allowed chunk length:" + this.maxChunkSize + " see NETWORK_BINARY_MAX_CONTENT_LENGTH settings "), null);
        }
        this.updateMetricReceivedBytes(4 + len);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read chunk lenght: %d", this.socket.getRemoteSocketAddress(), len);
        }
        if (len < 0) {
            return null;
        }
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Reading %d bytes...", this.socket.getRemoteSocketAddress(), len);
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Read %d bytes: %s", this.socket.getRemoteSocketAddress(), len, new String(tmp));
        }
        return tmp;
    }

    public ORecordId readRID() throws IOException {
        short clusterId = this.readShort();
        long clusterPosition = this.readLong();
        return new ORecordId(clusterId, clusterPosition);
    }

    public int readVersion() throws IOException {
        return this.readInt();
    }

    public OChannelBinary writeByte(byte iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing byte (1 byte): %d", this.socket.getRemoteSocketAddress(), iContent);
        }
        this.out.write(iContent);
        this.updateMetricTransmittedBytes(1);
        return this;
    }

    public OChannelBinary writeBoolean(boolean iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing boolean (1 byte): %b", this.socket.getRemoteSocketAddress(), iContent);
        }
        this.out.writeBoolean(iContent);
        this.updateMetricTransmittedBytes(1);
        return this;
    }

    public OChannelBinary writeInt(int iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing int (4 bytes): %d", this.socket.getRemoteSocketAddress(), iContent);
        }
        this.out.writeInt(iContent);
        this.updateMetricTransmittedBytes(4);
        return this;
    }

    public OChannelBinary writeLong(long iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing long (8 bytes): %d", this.socket.getRemoteSocketAddress(), iContent);
        }
        this.out.writeLong(iContent);
        this.updateMetricTransmittedBytes(8);
        return this;
    }

    public OChannelBinary writeShort(short iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing short (2 bytes): %d", this.socket.getRemoteSocketAddress(), iContent);
        }
        this.out.writeShort(iContent);
        this.updateMetricTransmittedBytes(2);
        return this;
    }

    public OChannelBinary writeString(String iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing string (4+%d=%d bytes): %s", this.socket.getRemoteSocketAddress(), iContent != null ? iContent.length() : 0, iContent != null ? iContent.length() + 4 : 4, iContent);
        }
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            byte[] buffer = iContent.getBytes();
            this.out.writeInt(buffer.length);
            this.out.write(buffer, 0, buffer.length);
            this.updateMetricTransmittedBytes(4 + buffer.length);
        }
        return this;
    }

    public OChannelBinary writeBytes(byte[] iContent) throws IOException {
        return this.writeBytes(iContent, iContent != null ? iContent.length : 0);
    }

    public OChannelBinary writeBytes(byte[] iContent, int iLength) throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Writing bytes (4+%d=%d bytes): %s", this.socket.getRemoteSocketAddress(), iLength, iLength + 4, Arrays.toString(iContent));
        }
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            if (iLength > this.maxChunkSize) {
                throw OException.wrapException(new OIOException("Impossible to write a chunk of length:" + iLength + " max allowed chunk length:" + this.maxChunkSize + " see NETWORK_BINARY_MAX_CONTENT_LENGTH settings "), null);
            }
            this.out.writeInt(iLength);
            this.out.write(iContent, 0, iLength);
            this.updateMetricTransmittedBytes(4 + iLength);
        }
        return this;
    }

    public void writeRID(ORID iRID) throws IOException {
        this.writeShort((short)iRID.getClusterId());
        this.writeLong(iRID.getClusterPosition());
    }

    public void writeVersion(int version) throws IOException {
        this.writeInt(version);
    }

    public void clearInput() throws IOException {
        if (this.in == null) {
            return;
        }
        StringBuilder dirtyBuffer = new StringBuilder(150);
        int i = 0;
        while (this.in.available() > 0) {
            char c = (char)this.in.read();
            ++i;
            if (dirtyBuffer.length() >= 150) continue;
            dirtyBuffer.append(c);
        }
        this.updateMetricReceivedBytes(i);
        String message = "Received unread response from " + this.socket.getRemoteSocketAddress() + " probably corrupted data from the network connection. Cleared dirty data in the buffer (" + i + " bytes): [" + dirtyBuffer + (i > dirtyBuffer.length() ? "..." : "") + "]";
        OLogManager.instance().error((Object)this, message, new Object[0]);
        throw new OIOException(message);
    }

    @Override
    public void flush() throws IOException {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Flush", this.socket != null ? " null possible previous close" : this.socket.getRemoteSocketAddress());
        }
        this.updateMetricFlushes();
        if (this.out != null) {
            this.out.flush();
        } else {
            super.flush();
        }
    }

    @Override
    public void close() {
        if (this.debug) {
            OLogManager.instance().info((Object)this, "%s - Closing socket...", this.socket != null ? " null possible previous close" : this.socket.getRemoteSocketAddress());
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            OLogManager.instance().debug((Object)this, "Error during closing of input stream", e, new Object[0]);
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            OLogManager.instance().debug((Object)this, "Error during closing of output stream", e, new Object[0]);
        }
        super.close();
    }

    public DataOutputStream getDataOutput() {
        return this.out;
    }

    public DataInputStream getDataInput() {
        return this.in;
    }
}

