/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.ScriptAssert;
import org.hibernate.validator.internal.constraintvalidators.hv.ScriptAssertContext;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;

public class ScriptAssertValidator
implements ConstraintValidator<ScriptAssert, Object> {
    private String alias;
    private ScriptAssertContext scriptAssertContext;

    public void initialize(ScriptAssert constraintAnnotation) {
        this.validateParameters(constraintAnnotation);
        this.alias = constraintAnnotation.alias();
        this.scriptAssertContext = new ScriptAssertContext(constraintAnnotation.lang(), constraintAnnotation.script());
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        return this.scriptAssertContext.evaluateScriptAssertExpression(value, this.alias);
    }

    private void validateParameters(ScriptAssert constraintAnnotation) {
        Contracts.assertNotEmpty(constraintAnnotation.script(), Messages.MESSAGES.parameterMustNotBeEmpty("script"));
        Contracts.assertNotEmpty(constraintAnnotation.lang(), Messages.MESSAGES.parameterMustNotBeEmpty("lang"));
        Contracts.assertNotEmpty(constraintAnnotation.alias(), Messages.MESSAGES.parameterMustNotBeEmpty("alias"));
    }
}

