/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.TransferQueueBundler;
import org.jgroups.util.AsciiString;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class SimplifiedTransferQueueBundler
extends TransferQueueBundler {
    protected static final int MSG_BUF_SIZE = 512;
    protected final Message[] msg_queue = new Message[512];
    protected int curr;

    protected SimplifiedTransferQueueBundler(int capacity) {
        super(new ArrayBlockingQueue<Message>(SimplifiedTransferQueueBundler.assertPositive(capacity, "bundler capacity cannot be " + capacity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addMessage(Message msg, long size) {
        try {
            while (this.curr < 512 && this.msg_queue[this.curr] != null) {
                ++this.curr;
            }
            if (this.curr < 512) {
                this.msg_queue[this.curr] = msg;
                ++this.curr;
            } else {
                this.sendBundledMessages();
                this.curr = 0;
                this.msg_queue[0] = msg;
            }
        }
        finally {
            this.count += size;
        }
    }

    @Override
    protected void sendBundledMessages() {
        int start = 0;
        while (true) {
            Message msg;
            int i;
            if (start < 512 && this.msg_queue[start] == null) {
                ++start;
                continue;
            }
            if (start >= 512) {
                this.count = 0L;
                return;
            }
            Address dest = this.msg_queue[start].getDest();
            byte[] clusterName = this.getMsgClusterName(this.msg_queue[start]);
            int numMsgs = 1;
            if (this.transport.isSingleton()) {
                for (i = start + 1; i < 512; ++i) {
                    msg = this.msg_queue[i];
                    if (msg == null || dest != msg.getDest() && (dest == null || !dest.equals(msg.getDest())) || !Arrays.equals(clusterName, this.getMsgClusterName(msg))) continue;
                    msg.setDest(dest);
                    ++numMsgs;
                }
            } else {
                for (i = start + 1; i < 512; ++i) {
                    msg = this.msg_queue[i];
                    if (msg == null || dest != msg.getDest() && (dest == null || !dest.equals(msg.getDest()))) continue;
                    msg.setDest(dest);
                    ++numMsgs;
                }
            }
            try {
                this.output.position(0);
                if (numMsgs == 1) {
                    this.sendSingleMessage(this.msg_queue[start], this.output);
                    this.msg_queue[start] = null;
                } else {
                    Util.writeMessageListHeader(dest, this.msg_queue[start].getSrc(), clusterName, numMsgs, this.output, dest == null);
                    for (i = start; i < 512; ++i) {
                        msg = this.msg_queue[i];
                        if (msg == null || msg.getDest() != dest) continue;
                        msg.writeToNoAddrs(msg.getSrc(), this.output, this.transport.getId());
                        this.msg_queue[i] = null;
                    }
                    this.transport.doSend(this.transport.isSingleton() ? new AsciiString(clusterName) : null, this.output.buffer(), 0, this.output.position(), dest);
                }
                ++start;
                continue;
            }
            catch (Exception e) {
                this.log.error("Failed to send message", e);
                continue;
            }
            break;
        }
    }

    private byte[] getMsgClusterName(Message msg) {
        return ((TpHeader)msg.getHeader((short)this.transport.getId())).cluster_name;
    }

    protected void sendSingleMessage(Message msg, ByteArrayDataOutputStream output) {
        Address dest = msg.getDest();
        try {
            Util.writeMessage(msg, output, dest == null);
            this.transport.doSend(this.transport.getClusterName(msg), output.buffer(), 0, output.position(), dest);
            if (this.transport.statsEnabled()) {
                this.transport.incrSingleMsgsInsteadOfBatches();
            }
        }
        catch (SocketException sock_ex) {
            this.log.trace(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), sock_ex.toString(), msg.printHeaders());
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }
}

