/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.interceptor;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.RejectionRule;

public class GracefulShutdownInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(GracefulShutdownInterceptor.class);

    public GracefulShutdownInterceptor() {
        super("read");
        this.addAfter(ReadHeadersInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        ServletRequest req = (ServletRequest)message.get((Object)"HTTP.REQUEST");
        if (req != null && "true".equals(req.getAttribute("org.wildfly.suspended"))) {
            if (message instanceof SoapMessage) {
                SoapMessage soapMessage = (SoapMessage)message;
                if (!soapMessage.hasHeaders()) {
                    throw this.createFault();
                }
                Deployment dep = ((Endpoint)soapMessage.getExchange().get(Endpoint.class)).getService().getDeployment();
                RejectionRule rr = (RejectionRule)dep.getAttachment(RejectionRule.class);
                if (rr != null) {
                    List headers = soapMessage.getHeaders();
                    HashMap<QName, Object> m = new HashMap<QName, Object>();
                    for (Header header : headers) {
                        m.put(header.getName(), header.getObject());
                    }
                    if (rr.rejectMessage(m)) {
                        throw this.createFault();
                    }
                }
            } else {
                throw this.createFault();
            }
        }
    }

    private Fault createFault() {
        Fault f = new Fault(new org.apache.cxf.common.i18n.Message("Server is suspended", LOG, new Object[0]));
        f.setStatusCode(503);
        return f;
    }
}

