/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.MulticastTransportConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class TransportRegistration
implements Registration<ManagementResourceRegistration> {
    private final ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory;

    public TransportRegistration(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this.parentBuilderFactory = parentBuilderFactory;
    }

    public void register(ManagementResourceRegistration registration) {
        new TransportResourceDefinition(address -> TransportType.MULTICAST.contains(address.getLastElement().getValue()) ? new MulticastTransportConfigurationBuilder(address) : new TransportConfigurationBuilder(address), this.parentBuilderFactory).register(registration);
    }

    static enum TransportType implements Iterable<String>
    {
        MULTICAST("UDP");

        private Set<String> transports;

        private TransportType(String transport) {
            this.transports = Collections.singleton(transport);
        }

        private TransportType(String ... transports) {
            this.transports = Collections.unmodifiableSet(Stream.of(transports).collect(Collectors.toSet()));
        }

        @Override
        public Iterator<String> iterator() {
            return this.transports.iterator();
        }

        Stream<String> stream() {
            return this.transports.stream();
        }

        boolean contains(String transport) {
            return this.transports.contains(transport);
        }
    }
}

