/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.DeploymentSetPlan;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlan;

public class DeploymentSetPlanImpl
implements DeploymentSetPlan,
Serializable {
    private static final long serialVersionUID = -7652253540766375101L;
    private final UUID uuid;
    private final List<DeploymentAction> deploymentActions = new ArrayList<DeploymentAction>();
    private final boolean rollback;
    private final boolean shutdown;
    private final long gracefulShutdownPeriod;
    private final List<Set<ServerGroupDeploymentPlan>> serverGroupPlans = new ArrayList<Set<ServerGroupDeploymentPlan>>();

    DeploymentSetPlanImpl() {
        this.uuid = UUID.randomUUID();
        this.rollback = true;
        this.shutdown = false;
        this.gracefulShutdownPeriod = -1L;
        this.serverGroupPlans.add(new LinkedHashSet());
    }

    private DeploymentSetPlanImpl(UUID uuid, List<DeploymentAction> actions, List<Set<ServerGroupDeploymentPlan>> serverGroupPlans, boolean rollback, boolean shutdown, long gracefulTimeout) {
        this.uuid = uuid;
        this.deploymentActions.addAll(actions);
        this.rollback = rollback;
        this.shutdown = shutdown;
        this.gracefulShutdownPeriod = gracefulTimeout;
        this.serverGroupPlans.addAll(serverGroupPlans);
        LinkedHashSet last = (LinkedHashSet)serverGroupPlans.get(serverGroupPlans.size() - 1);
        this.serverGroupPlans.set(serverGroupPlans.size() - 1, new LinkedHashSet(last));
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    public DeploymentAction getLastAction() {
        return this.deploymentActions.size() == 0 ? null : this.deploymentActions.get(this.deploymentActions.size() - 1);
    }

    @Override
    public List<DeploymentAction> getDeploymentActions() {
        return new ArrayList<DeploymentAction>(this.deploymentActions);
    }

    @Override
    public boolean isRollback() {
        return this.rollback;
    }

    @Override
    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownPeriod;
    }

    @Override
    public boolean isGracefulShutdown() {
        return this.shutdown && this.gracefulShutdownPeriod > -1L;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public List<Set<ServerGroupDeploymentPlan>> getServerGroupDeploymentPlans() {
        List copy = null;
        if (this.serverGroupPlans != null) {
            copy = new ArrayList(this.serverGroupPlans.size());
            for (Set<ServerGroupDeploymentPlan> set : this.serverGroupPlans) {
                copy.add(Collections.unmodifiableSet(new LinkedHashSet<ServerGroupDeploymentPlan>(set)));
            }
        } else {
            copy = Collections.emptyList();
        }
        return Collections.unmodifiableList(copy);
    }

    boolean hasServerGroupPlans() {
        return this.serverGroupPlans.size() > 1 || this.serverGroupPlans.get(0).size() > 0;
    }

    ServerGroupDeploymentPlan getLatestServerGroupDeploymentPlan() {
        LinkedHashSet lastSet = (LinkedHashSet)this.serverGroupPlans.get(this.serverGroupPlans.size() - 1);
        ServerGroupDeploymentPlan last = null;
        Iterator iterator = lastSet.iterator();
        while (iterator.hasNext()) {
            ServerGroupDeploymentPlan plan;
            last = plan = (ServerGroupDeploymentPlan)iterator.next();
        }
        return last;
    }

    DeploymentSetPlanImpl addAction(DeploymentAction action) {
        DeploymentSetPlanImpl result = new DeploymentSetPlanImpl(this.uuid, this.deploymentActions, this.serverGroupPlans, this.rollback, this.shutdown, this.gracefulShutdownPeriod);
        result.deploymentActions.add(action);
        return result;
    }

    DeploymentSetPlanImpl setRollback() {
        DeploymentSetPlanImpl result = new DeploymentSetPlanImpl(this.uuid, this.deploymentActions, this.serverGroupPlans, true, this.shutdown, this.gracefulShutdownPeriod);
        return result;
    }

    DeploymentSetPlanImpl setNoRollback() {
        DeploymentSetPlanImpl result = new DeploymentSetPlanImpl(this.uuid, this.deploymentActions, this.serverGroupPlans, false, this.shutdown, this.gracefulShutdownPeriod);
        return result;
    }

    DeploymentSetPlanImpl setShutdown() {
        DeploymentSetPlanImpl result = new DeploymentSetPlanImpl(this.uuid, this.deploymentActions, this.serverGroupPlans, this.rollback, true, -1L);
        return result;
    }

    DeploymentSetPlanImpl setGracefulTimeout(long timeout) {
        DeploymentSetPlanImpl result = new DeploymentSetPlanImpl(this.uuid, this.deploymentActions, this.serverGroupPlans, this.rollback, this.shutdown, timeout);
        return result;
    }

    DeploymentSetPlanImpl storeServerGroup(ServerGroupDeploymentPlan groupPlan) {
        DeploymentSetPlanImpl result = new DeploymentSetPlanImpl(this.uuid, this.deploymentActions, this.serverGroupPlans, this.rollback, this.shutdown, this.gracefulShutdownPeriod);
        Set<ServerGroupDeploymentPlan> set = result.serverGroupPlans.get(result.serverGroupPlans.size() - 1);
        set.remove(groupPlan);
        set.add(groupPlan);
        return result;
    }

    DeploymentSetPlanImpl storeRollToServerGroup(ServerGroupDeploymentPlan groupPlan) {
        DeploymentSetPlanImpl result = new DeploymentSetPlanImpl(this.uuid, this.deploymentActions, this.serverGroupPlans, this.rollback, this.shutdown, this.gracefulShutdownPeriod);
        Set<ServerGroupDeploymentPlan> set = result.serverGroupPlans.get(result.serverGroupPlans.size() - 1);
        result.serverGroupPlans.set(result.serverGroupPlans.size() - 1, Collections.unmodifiableSet(set));
        set = new LinkedHashSet<ServerGroupDeploymentPlan>();
        set.add(groupPlan);
        result.serverGroupPlans.add(set);
        return result;
    }
}

