/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.neo4j;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.neo4j.ConfigurationBuilder;
import org.wildfly.extension.nosql.driver.neo4j.Neo4jInteraction;
import org.wildfly.extension.nosql.driver.neo4j.transaction.DriverProxy;
import org.wildfly.extension.nosql.driver.neo4j.transaction.TransactionEnlistmentType;
import org.wildfly.extension.nosql.subsystem.neo4j.Neo4jSubsystemService;
import org.wildfly.nosql.common.NoSQLLogger;
import org.wildfly.nosql.common.spi.NoSQLConnection;

public class Neo4jClientConnectionService
implements Service<Neo4jClientConnectionService>,
NoSQLConnection {
    private final ConfigurationBuilder configurationBuilder;
    private Map<String, OutboundSocketBinding> outboundSocketBindings = new HashMap<String, OutboundSocketBinding>();
    private final Neo4jInteraction neo4jInteraction;
    private Object driver;
    private final InjectedValue<Neo4jSubsystemService> neo4jSubsystemServiceInjectedValue = new InjectedValue();
    private final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();

    public InjectedValue<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    public InjectedValue<Neo4jSubsystemService> getNeo4jSubsystemServiceInjectedValue() {
        return this.neo4jSubsystemServiceInjectedValue;
    }

    public Neo4jClientConnectionService(ConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
        this.neo4jInteraction = new Neo4jInteraction(configurationBuilder);
    }

    public Injector<OutboundSocketBinding> getOutboundSocketBindingInjector(String name) {
        return new MapInjector(this.outboundSocketBindings, (Object)name);
    }

    public void start(StartContext startContext) throws StartException {
        ((Neo4jSubsystemService)this.neo4jSubsystemServiceInjectedValue.getValue()).addModuleNameFromJndi(this.configurationBuilder.getJNDIName(), this.configurationBuilder.getModuleName());
        ((Neo4jSubsystemService)this.neo4jSubsystemServiceInjectedValue.getValue()).addModuleNameFromProfile(this.configurationBuilder.getDescription(), this.configurationBuilder.getModuleName());
        for (OutboundSocketBinding target : this.outboundSocketBindings.values()) {
            if (target.getUnresolvedDestinationAddress() != null) {
                this.neo4jInteraction.addContactPoint(target.getUnresolvedDestinationAddress());
            }
            if (target.getDestinationPort() > 0) {
                this.neo4jInteraction.withPort(target.getDestinationPort());
            }
            if (this.subjectFactory.getOptionalValue() == null) continue;
            this.neo4jInteraction.subjectFactory((SubjectFactory)this.subjectFactory.getOptionalValue());
        }
        try {
            this.driver = this.neo4jInteraction.build();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("could not setup ServerAddress for " + this.configurationBuilder.getDescription(), throwable);
        }
        if (TransactionEnlistmentType.ONEPHASECOMMIT.equals((Object)this.configurationBuilder.getTransactionEnlistment())) {
            this.driver = this.onePhaseCommitWrapper(this.driver, ((Neo4jSubsystemService)this.neo4jSubsystemServiceInjectedValue.getValue()).transactionManager(), ((Neo4jSubsystemService)this.neo4jSubsystemServiceInjectedValue.getValue()).transactionSynchronizationRegistry());
        }
    }

    private Object onePhaseCommitWrapper(Object driver, TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        return Proxy.newProxyInstance(this.neo4jInteraction.getDriverClass().getClassLoader(), new Class[]{this.neo4jInteraction.getDriverClass()}, (InvocationHandler)new DriverProxy(driver, transactionManager, transactionSynchronizationRegistry, this.configurationBuilder.getDescription(), this.configurationBuilder.getJNDIName()));
    }

    public void stop(StopContext stopContext) {
        try {
            ((Neo4jSubsystemService)this.neo4jSubsystemServiceInjectedValue.getValue()).removeModuleNameFromJndi(this.configurationBuilder.getJNDIName());
            ((Neo4jSubsystemService)this.neo4jSubsystemServiceInjectedValue.getValue()).removeModuleNameFromProfile(this.configurationBuilder.getDescription());
            this.neo4jInteraction.driverClose(this.driver);
            this.driver = null;
        }
        catch (Throwable throwable) {
            NoSQLLogger.ROOT_LOGGER.driverFailedToStop(throwable);
        }
    }

    public Neo4jClientConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Object getDriver() {
        return this.driver;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (this.neo4jInteraction.getDriverClass().isAssignableFrom(clazz)) {
            return (T)this.driver;
        }
        throw NoSQLLogger.ROOT_LOGGER.unassignable(clazz);
    }
}

