/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.neo4j;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.StartException;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.neo4j.ConfigurationBuilder;
import org.wildfly.nosql.common.MethodHandleBuilder;
import org.wildfly.nosql.common.NoSQLLogger;

public class Neo4jInteraction {
    private StringBuffer builder = new StringBuffer("");
    private final Class driverClass;
    private final MethodHandle closeDriverMethod;
    private final MethodHandle buildMethod;
    private final MethodHandle buildWithAuthMethod;
    private final MethodHandle basicAuthMethod;
    private volatile SubjectFactory subjectFactory;
    private final String securityDomain;

    public Neo4jInteraction(ConfigurationBuilder configurationBuilder) {
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        methodHandleBuilder.classLoader(ModuleIdentifier.fromString((String)configurationBuilder.getModuleName()));
        Class authTokenClass = methodHandleBuilder.className("org.neo4j.driver.v1.AuthToken").getTargetClass();
        methodHandleBuilder.className("org.neo4j.driver.v1.AuthTokens").getTargetClass();
        this.basicAuthMethod = methodHandleBuilder.staticMethod("basic", MethodType.methodType(authTokenClass, String.class, String.class));
        this.driverClass = methodHandleBuilder.className("org.neo4j.driver.v1.Driver").getTargetClass();
        this.closeDriverMethod = methodHandleBuilder.method("close", new Class[0]);
        methodHandleBuilder.className("org.neo4j.driver.v1.GraphDatabase");
        this.buildMethod = methodHandleBuilder.staticMethod("driver", MethodType.methodType(this.driverClass, String.class));
        this.buildWithAuthMethod = methodHandleBuilder.staticMethod("driver", MethodType.methodType(this.driverClass, String.class, authTokenClass));
        this.securityDomain = configurationBuilder.getSecurityDomain();
    }

    public void subjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    protected Object build() throws Throwable {
        if (this.securityDomain != null && this.subjectFactory != null) {
            try {
                Subject subject = this.subjectFactory.createSubject(this.securityDomain);
                Set<PasswordCredential> passwordCredentials = subject.getPrivateCredentials(PasswordCredential.class);
                PasswordCredential passwordCredential = passwordCredentials.iterator().next();
                return this.buildWithAuthMethod.invoke(this.builder.toString(), this.basicAuthMethod.invoke(passwordCredential.getUserName(), new String(passwordCredential.getPassword())));
            }
            catch (Throwable problem) {
                if (NoSQLLogger.ROOT_LOGGER.isTraceEnabled()) {
                    NoSQLLogger.ROOT_LOGGER.tracef(problem, "could not create subject for security domain '%s'", (Object)this.securityDomain);
                }
                throw problem;
            }
        }
        return this.buildMethod.invoke(this.builder.toString());
    }

    protected void withPort(int port) throws StartException {
        this.add(":");
        this.add(Integer.toString(port));
    }

    protected void addContactPoint(String host) throws StartException {
        this.add(host);
    }

    private void add(String value) {
        if (this.builder.length() == 0) {
            this.builder.append("bolt://");
        }
        this.builder.append(value);
    }

    protected void driverClose(Object driver) throws Throwable {
        this.closeDriverMethod.invoke(driver);
    }

    protected Class getDriverClass() {
        return this.driverClass;
    }
}

