/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;

public class ActiveMQStompProtocolMessageBundle_$bundle
implements ActiveMQStompProtocolMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQStompProtocolMessageBundle_$bundle INSTANCE = new ActiveMQStompProtocolMessageBundle_$bundle();
    private static final String negativeConnectionTTL = "AMQ339000: Stomp Connection TTL cannot be negative: {0}";
    private static final String destinationNotExist = "AMQ339001: Destination does not exist: {0}";
    private static final String versionNotSupported = "AMQ339002: Stomp versions not supported: {0}";
    private static final String nullHostHeader = "AMQ339003: Header host is null";
    private static final String hostCannotBeNull = "AMQ339004: Cannot accept null as host";
    private static final String hostNotMatch = "AMQ339005: Header host does not match server host";
    private static final String hostNotMatchDetails = "AMQ339006: host {0} does not match server host name";
    private static final String connectionDestroyed = "AMQ339007: Connection was destroyed.";
    private static final String connectionNotEstablished = "AMQ339008: Connection has not been established.";
    private static final String errorGetSession = "AMQ339009: Exception getting session";
    private static final String invalidConnection = "AMQ339010: Connection is not valid.";
    private static final String errorSendMessage = "AMQ339011: Error sending message {0}";
    private static final String errorBeginTx = "AMQ339012: Error beginning a transaction {0}";
    private static final String errorCommitTx = "AMQ339013: Error committing {0}";
    private static final String errorAbortTx = "AMQ339014: Error aborting {0}";
    private static final String noDestination = "AMQ339015: Client must set destination or id header to a SUBSCRIBE command";
    private static final String errorCreatSubscription = "AMQ339016: Error creating subscription {0}";
    private static final String errorUnsubscrib = "AMQ339017: Error unsubscribing {0}";
    private static final String errorAck = "AMQ339018: Error acknowledging message {0}";
    private static final String invalidTwoCRs = "AMQ339019: Invalid char sequence: two consecutive CRs.";
    private static final String badCRs = "AMQ339020: Invalid char sequence: There is a CR not followed by an LF";
    private static final String notValidNewLine = "AMQ339021: Expect new line char but is {0}";
    private static final String unexpectedNewLine = "AMQ339022: Expect new line char but is {0}";
    private static final String invalidCommand = "AMQ339023: Invalid STOMP frame: {0}";
    private static final String invalidFrame = "AMQ339024: Invalid STOMP frame: {0}";
    private static final String failToAckMissingID = "AMQ339025: failed to ack because no message with id: {0}";
    private static final String subscriptionIDMismatch = "AMQ339026: subscription id {0} does not match {1}";
    private static final String missingClientID = "AMQ339027: Cannot create a subscriber on the durable subscription if the client-id of the connection is not set";
    private static final String headerTooBig = "AMQ339028: Message header too big, increase minLargeMessageSize please.";
    private static final String unknownCommand = "AMQ339029: Unsupported command: {0}";
    private static final String needTxIDHeader = "AMQ339030: transaction header is mandatory to COMMIT a transaction";
    private static final String errorHandleSend = "AMQ339031: Error handling send";
    private static final String beginTxNoID = "AMQ339032: Need a transaction id to begin";
    private static final String abortTxNoID = "AMQ339033: transaction header is mandatory to ABORT a transaction";
    private static final String invalidCall = "AMQ339034: This method should not be called";
    private static final String needIDorDestination = "AMQ339035: Must specify the subscription''s id or the destination you are unsubscribing from";
    private static final String needSubscriptionID = "AMQ339037: Must specify the subscription''s id";
    private static final String noIDInAck = "AMQ339039: No id header in ACK/NACK frame.";
    private static final String undefinedEscapeSequence = "AMQ339040: Undefined escape sequence: {0}";

    protected ActiveMQStompProtocolMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected String negativeConnectionTTL$str() {
        return negativeConnectionTTL;
    }

    @Override
    public final IllegalStateException negativeConnectionTTL(Long ttl) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format(this.negativeConnectionTTL$str(), ttl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destinationNotExist$str() {
        return destinationNotExist;
    }

    @Override
    public final ActiveMQStompException destinationNotExist(String destination) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.destinationNotExist$str(), destination));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String versionNotSupported$str() {
        return versionNotSupported;
    }

    @Override
    public final ActiveMQStompException versionNotSupported(String acceptVersion) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.versionNotSupported$str(), acceptVersion));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullHostHeader$str() {
        return nullHostHeader;
    }

    @Override
    public final ActiveMQStompException nullHostHeader() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.nullHostHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostCannotBeNull$str() {
        return hostCannotBeNull;
    }

    @Override
    public final String hostCannotBeNull() {
        return String.format(this.hostCannotBeNull$str(), new Object[0]);
    }

    protected String hostNotMatch$str() {
        return hostNotMatch;
    }

    @Override
    public final ActiveMQStompException hostNotMatch() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.hostNotMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostNotMatchDetails$str() {
        return hostNotMatchDetails;
    }

    @Override
    public final String hostNotMatchDetails(String host) {
        return MessageFormat.format(this.hostNotMatchDetails$str(), host);
    }

    protected String connectionDestroyed$str() {
        return connectionDestroyed;
    }

    @Override
    public final ActiveMQStompException connectionDestroyed() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.connectionDestroyed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionNotEstablished$str() {
        return connectionNotEstablished;
    }

    @Override
    public final ActiveMQStompException connectionNotEstablished() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.connectionNotEstablished$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorGetSession$str() {
        return errorGetSession;
    }

    @Override
    public final ActiveMQStompException errorGetSession(Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.errorGetSession$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnection$str() {
        return invalidConnection;
    }

    @Override
    public final ActiveMQStompException invalidConnection() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.invalidConnection$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorSendMessage$str() {
        return errorSendMessage;
    }

    @Override
    public final ActiveMQStompException errorSendMessage(ServerMessageImpl message, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.errorSendMessage$str(), message), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorBeginTx$str() {
        return errorBeginTx;
    }

    @Override
    public final ActiveMQStompException errorBeginTx(String txID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.errorBeginTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCommitTx$str() {
        return errorCommitTx;
    }

    @Override
    public final ActiveMQStompException errorCommitTx(String txID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.errorCommitTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAbortTx$str() {
        return errorAbortTx;
    }

    @Override
    public final ActiveMQStompException errorAbortTx(String txID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.errorAbortTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDestination$str() {
        return noDestination;
    }

    @Override
    public final ActiveMQStompException noDestination() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.noDestination$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatSubscription$str() {
        return errorCreatSubscription;
    }

    @Override
    public final ActiveMQStompException errorCreatSubscription(String subscriptionID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.errorCreatSubscription$str(), subscriptionID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorUnsubscrib$str() {
        return errorUnsubscrib;
    }

    @Override
    public final ActiveMQStompException errorUnsubscrib(String subscriptionID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.errorUnsubscrib$str(), subscriptionID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAck$str() {
        return errorAck;
    }

    @Override
    public final ActiveMQStompException errorAck(String messageID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.errorAck$str(), messageID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTwoCRs$str() {
        return invalidTwoCRs;
    }

    @Override
    public final ActiveMQStompException invalidTwoCRs() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.invalidTwoCRs$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String badCRs$str() {
        return badCRs;
    }

    @Override
    public final ActiveMQStompException badCRs() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.badCRs$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notValidNewLine$str() {
        return notValidNewLine;
    }

    @Override
    public final ActiveMQStompException notValidNewLine(byte b) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.notValidNewLine$str(), b));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedNewLine$str() {
        return unexpectedNewLine;
    }

    @Override
    public final String unexpectedNewLine(byte b) {
        return MessageFormat.format(this.unexpectedNewLine$str(), b);
    }

    protected String invalidCommand$str() {
        return invalidCommand;
    }

    @Override
    public final ActiveMQStompException invalidCommand(String dumpByteArray) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.invalidCommand$str(), dumpByteArray));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFrame$str() {
        return invalidFrame;
    }

    @Override
    public final String invalidFrame(String dumpByteArray) {
        return MessageFormat.format(this.invalidFrame$str(), dumpByteArray);
    }

    protected String failToAckMissingID$str() {
        return failToAckMissingID;
    }

    @Override
    public final ActiveMQStompException failToAckMissingID(long id) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.failToAckMissingID$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String subscriptionIDMismatch$str() {
        return subscriptionIDMismatch;
    }

    @Override
    public final ActiveMQStompException subscriptionIDMismatch(String subscriptionID, String actualID) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.subscriptionIDMismatch$str(), subscriptionID, actualID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingClientID$str() {
        return missingClientID;
    }

    @Override
    public final IllegalStateException missingClientID() {
        IllegalStateException result = new IllegalStateException(String.format(this.missingClientID$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String headerTooBig$str() {
        return headerTooBig;
    }

    @Override
    public final Exception headerTooBig() {
        Exception result = new Exception(String.format(this.headerTooBig$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownCommand$str() {
        return unknownCommand;
    }

    @Override
    public final ActiveMQStompException unknownCommand(String command) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.unknownCommand$str(), command));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needTxIDHeader$str() {
        return needTxIDHeader;
    }

    @Override
    public final ActiveMQStompException needTxIDHeader() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.needTxIDHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorHandleSend$str() {
        return errorHandleSend;
    }

    @Override
    public final ActiveMQStompException errorHandleSend(Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.errorHandleSend$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String beginTxNoID$str() {
        return beginTxNoID;
    }

    @Override
    public final ActiveMQStompException beginTxNoID() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.beginTxNoID$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String abortTxNoID$str() {
        return abortTxNoID;
    }

    @Override
    public final ActiveMQStompException abortTxNoID() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.abortTxNoID$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCall$str() {
        return invalidCall;
    }

    @Override
    public final IllegalStateException invalidCall() {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidCall$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needIDorDestination$str() {
        return needIDorDestination;
    }

    @Override
    public final ActiveMQStompException needIDorDestination() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.needIDorDestination$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needSubscriptionID$str() {
        return needSubscriptionID;
    }

    @Override
    public final ActiveMQStompException needSubscriptionID() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.needSubscriptionID$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noIDInAck$str() {
        return noIDInAck;
    }

    @Override
    public final ActiveMQStompException noIDInAck() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.noIDInAck$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String undefinedEscapeSequence$str() {
        return undefinedEscapeSequence;
    }

    @Override
    public final ActiveMQStompException undefinedEscapeSequence(String sequence) {
        ActiveMQStompException result = new ActiveMQStompException(MessageFormat.format(this.undefinedEscapeSequence$str(), sequence));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

