/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.exception;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OHighLevelException;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;

public class OConcurrentModificationException
extends ONeedRetryException
implements OHighLevelException {
    private static final long serialVersionUID = 1L;
    private ORID rid;
    private int databaseVersion = 0;
    private int recordVersion = 0;
    private int recordOperation;

    public OConcurrentModificationException(OConcurrentModificationException exception) {
        super(exception);
        this.rid = exception.rid;
        this.recordVersion = exception.recordVersion;
        this.databaseVersion = exception.databaseVersion;
        this.recordOperation = exception.recordOperation;
    }

    protected OConcurrentModificationException(String message) {
        super(message);
    }

    public OConcurrentModificationException(ORID iRID, int iDatabaseVersion, int iRecordVersion, int iRecordOperation) {
        super(OConcurrentModificationException.makeMessage(iRecordOperation, iRID, iDatabaseVersion, iRecordVersion));
        if (OFastConcurrentModificationException.enabled()) {
            throw new IllegalStateException("Fast-throw is enabled. Use OFastConcurrentModificationException.instance() instead");
        }
        this.rid = iRID;
        this.databaseVersion = iDatabaseVersion;
        this.recordVersion = iRecordVersion;
        this.recordOperation = iRecordOperation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OConcurrentModificationException)) {
            return false;
        }
        OConcurrentModificationException other = (OConcurrentModificationException)obj;
        if (this.recordOperation == other.recordOperation && this.rid.equals(other.rid) && this.databaseVersion == other.databaseVersion) {
            return this.recordOperation == other.recordOperation;
        }
        return false;
    }

    public int getEnhancedDatabaseVersion() {
        return this.databaseVersion;
    }

    public int getEnhancedRecordVersion() {
        return this.recordVersion;
    }

    public ORID getRid() {
        return this.rid;
    }

    private static String makeMessage(int recordOperation, ORID rid, int databaseVersion, int recordVersion) {
        String operation = ORecordOperation.getName(recordOperation);
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot ");
        sb.append(operation);
        sb.append(" the record ");
        sb.append(rid);
        sb.append(" because the version is not the latest. Probably you are ");
        sb.append(operation.toLowerCase().substring(0, operation.length() - 1));
        sb.append("ing an old record or it has been modified by another user (db=v");
        sb.append(databaseVersion);
        sb.append(" your=v");
        sb.append(recordVersion);
        sb.append(")");
        return sb.toString();
    }
}

