/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class OIndexMultiValues
extends OIndexAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String name, String type, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, type, algorithm, valueContainerAlgorithm, metadata, version, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object key) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            Set values;
            block10: {
                Set<OIdentifiable> set;
                this.acquireSharedLock();
                try {
                    values = (Set)this.storage.getIndexValue(this.indexId, key);
                    if (values != null) break block10;
                    set = Collections.emptySet();
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return set;
            }
            Set<OIdentifiable> set = Collections.unmodifiableSet(values);
            this.releaseSharedLock();
            return set;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Object key) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            Set values;
            block10: {
                long l;
                this.acquireSharedLock();
                try {
                    values = (Set)this.storage.getIndexValue(this.indexId, key);
                    if (values != null) break block10;
                    l = 0L;
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return l;
            }
            long l = values.size();
            this.releaseSharedLock();
            return l;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexMultiValues put(Object key, OIdentifiable singleValue) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            OIndexMultiValues oIndexMultiValues;
            this.acquireSharedLock();
            try {
                if (!singleValue.getIdentity().isValid()) {
                    singleValue.getRecord().save();
                }
                final ORID identity = singleValue.getIdentity();
                final boolean durable = this.metadata != null && Boolean.TRUE.equals(this.metadata.field("durableInNonTxMode"));
                final Set values = (Set)this.storage.getIndexValue(this.indexId, key);
                Callable<Object> creator = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Set result = values;
                        if (result == null) {
                            if ("SBTREEBONSAISET".equals(OIndexMultiValues.this.valueContainerAlgorithm)) {
                                result = new OIndexRIDContainer(OIndexMultiValues.this.getName(), durable);
                            } else {
                                throw new IllegalStateException("MVRBTree is not supported any more");
                            }
                        }
                        result.add(identity);
                        return result;
                    }
                };
                this.storage.updateIndexEntry(this.indexId, key, creator);
                oIndexMultiValues = this;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oIndexMultiValues;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            Set values;
            block10: {
                boolean bl;
                this.acquireSharedLock();
                try {
                    values = (Set)this.storage.getIndexValue(this.indexId, key);
                    if (values != null) break block10;
                    bl = false;
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return bl;
            }
            OModifiableBoolean removed = new OModifiableBoolean(false);
            EntityRemover creator = new EntityRemover(value, removed, values);
            this.storage.updateIndexEntry(this.indexId, key, creator);
            boolean bl = removed.getValue();
            this.releaseSharedLock();
            return bl;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    protected OBinarySerializer determineValueSerializer() {
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        final ArrayList sortedKeys = new ArrayList(keys);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        Collections.sort(sortedKeys, comparator);
        return new OIndexAbstractCursor(){
            private Iterator<?> keysIterator;
            private Iterator<OIdentifiable> currentIterator;
            private Object currentKey;
            {
                this.keysIterator = sortedKeys.iterator();
                this.currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                Object key = null;
                if (!this.currentIterator.hasNext()) {
                    Collection result = null;
                    while (this.keysIterator.hasNext() && (result == null || result.isEmpty())) {
                        key = this.keysIterator.next();
                        key = OIndexMultiValues.this.getCollatingValue(key);
                        OIndexMultiValues.this.acquireSharedLock();
                        try {
                            result = (Collection)OIndexMultiValues.this.storage.getIndexValue(OIndexMultiValues.this.indexId, key);
                        }
                        finally {
                            OIndexMultiValues.this.releaseSharedLock();
                        }
                    }
                    if (result == null) {
                        this.currentIterator = null;
                        return null;
                    }
                    this.currentKey = key;
                    this.currentIterator = result.iterator();
                }
                final OIdentifiable resultValue = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public long getSize() {
        this.acquireSharedLock();
        try {
            long l = this.storage.getIndexSize(this.indexId, MultiValuesTransformer.INSTANCE);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.acquireSharedLock();
        try {
            long l = this.storage.getIndexSize(this.indexId, null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.getIndexCursor(this.indexId, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.getIndexDescCursor(this.indexId, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static class EntityRemover
    implements Callable<Object> {
        private final OIdentifiable value;
        private final OModifiableBoolean removed;
        private final Set<OIdentifiable> values;

        public EntityRemover(OIdentifiable value, OModifiableBoolean removed, Set<OIdentifiable> values) {
            this.value = value;
            this.removed = removed;
            this.values = values;
        }

        @Override
        public Object call() throws Exception {
            if (this.value == null) {
                this.removed.setValue(true);
                return null;
            }
            if (this.values.remove(this.value)) {
                this.removed.setValue(true);
                if (this.values.isEmpty()) {
                    return null;
                }
                return this.values;
            }
            return this.values;
        }
    }

    private static final class MultiValuesTransformer
    implements OIndexEngine.ValuesTransformer {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<OIdentifiable> transformFromValue(Object value) {
            return (Collection)value;
        }
    }
}

