/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.security.PrivilegedAction;

final class ModuleClassLoaderAction
implements PrivilegedAction<ClassLoader> {
    static final ClassLoader SAFE_CL;
    private final Module module;

    ModuleClassLoaderAction(Module module) {
        this.module = module;
    }

    @Override
    public ClassLoader run() {
        ClassLoader classLoader = this.module.getClassLoader();
        return classLoader == null ? SAFE_CL : classLoader;
    }

    static {
        ClassLoader safeClassLoader = ModuleClassLoaderAction.class.getClassLoader();
        if (safeClassLoader == null) {
            safeClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (safeClassLoader == null) {
            safeClassLoader = new /* Unavailable Anonymous Inner Class!! */;
        }
        SAFE_CL = safeClassLoader;
    }
}

