/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.bootablejar.runtime._private;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.bootablejar.runtime._private.BootableJarLogger;

public class BootableJarLogger_$logger
extends DelegatingBasicLogger
implements BootableJarLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BootableJarLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public BootableJarLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void shuttingDown() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.shuttingDown$str(), new Object[0]);
    }

    protected String shuttingDown$str() {
        return "WFLYJAR0001: Shutting down";
    }

    @Override
    public final void serverStopped() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.serverStopped$str(), new Object[0]);
    }

    protected String serverStopped$str() {
        return "WFLYJAR0002: Server stopped, exiting";
    }

    @Override
    public final void serverNotStopped() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.serverNotStopped$str(), new Object[0]);
    }

    protected String serverNotStopped$str() {
        return "WFLYJAR0003: Server not yet stopped, waiting";
    }

    @Override
    public final void nullController() {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.nullController$str(), new Object[0]);
    }

    protected String nullController$str() {
        return "WFLYJAR0004: Null controller client, exiting";
    }

    protected String unexpectedExceptionWhileShuttingDown$str() {
        return "WFLYJAR0005: Unexpected exception while shutting down server";
    }

    @Override
    public final RuntimeException unexpectedExceptionWhileShuttingDown(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unexpectedExceptionWhileShuttingDown$str(), new Object[0]), cause);
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void installDeployment(Path dep) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.installDeployment$str(), (Object)dep);
    }

    protected String installDeployment$str() {
        return "WFLYJAR0006: Installed %s in server deployments";
    }

    @Override
    public final void advertiseInstall(Path home, long duration) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.advertiseInstall$str(), (Object)home, (Object)duration);
    }

    protected String advertiseInstall$str() {
        return "WFLYJAR0007: Installed server and application in %s, took %sms";
    }

    @Override
    public final void advertiseOptions(List<String> options) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.advertiseOptions$str(), (Object)options);
    }

    protected String advertiseOptions$str() {
        return "WFLYJAR0008: Server options: %s";
    }

    @Override
    public final void deletingHome(Path dep) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.deletingHome$str(), (Object)dep);
    }

    protected String deletingHome$str() {
        return "WFLYJAR0009: Deleting %s dir";
    }

    protected String argPublicBindAddress$str() {
        return "Set system property jboss.bind.address to the given value";
    }

    @Override
    public final String argPublicBindAddress() {
        return String.format(this.getLoggingLocale(), this.argPublicBindAddress$str(), new Object[0]);
    }

    protected String argInterfaceBindAddress$str() {
        return "Set system property jboss.bind.address.<interface> to the given value";
    }

    @Override
    public final String argInterfaceBindAddress() {
        return String.format(this.getLoggingLocale(), this.argInterfaceBindAddress$str(), new Object[0]);
    }

    protected String argSystem$str() {
        return "Set a system property";
    }

    @Override
    public final String argSystem() {
        return String.format(this.getLoggingLocale(), this.argSystem$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return "Display this message and exit";
    }

    @Override
    public final String argHelp() {
        return String.format(this.getLoggingLocale(), this.argHelp$str(), new Object[0]);
    }

    protected String argProperties$str() {
        return "Load system properties from the given url";
    }

    @Override
    public final String argProperties() {
        return String.format(this.getLoggingLocale(), this.argProperties$str(), new Object[0]);
    }

    protected String argDefaultMulticastAddress$str() {
        return "Set system property jboss.default.multicast.address to the given value";
    }

    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(this.getLoggingLocale(), this.argDefaultMulticastAddress$str(), new Object[0]);
    }

    protected String argVersion$str() {
        return "Print version and exit";
    }

    @Override
    public final String argVersion() {
        return String.format(this.getLoggingLocale(), this.argVersion$str(), new Object[0]);
    }

    protected String argSecurityProperty$str() {
        return "Set a security property";
    }

    @Override
    public final String argSecurityProperty() {
        return String.format(this.getLoggingLocale(), this.argSecurityProperty$str(), new Object[0]);
    }

    protected String argDeployment$str() {
        return "Path to deployment artifact (war,jar,ear or exploded deployment dir) to deploy in hollow jar";
    }

    @Override
    public final String argDeployment() {
        return String.format(this.getLoggingLocale(), this.argDeployment$str(), new Object[0]);
    }

    protected String argInstallation$str() {
        return "Path to directory in which the server is installed. By default the server is installed in TEMP directory.";
    }

    @Override
    public final String argInstallation() {
        return String.format(this.getLoggingLocale(), this.argInstallation$str(), new Object[0]);
    }
}

