/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.as.process.protocol.StreamUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class ProcessUtils {
    private static final ProcessUtils processUtils = File.pathSeparatorChar == ':' ? new UnixProcessUtils() : new WindowsProcessUtils();
    private static final String modulesJar = "jboss-modules.jar";

    ProcessUtils() {
    }

    static boolean killProcess(String processName, int id) {
        try {
            int pid = processUtils.resolveProcessId(processName, id);
            if (pid > 0) {
                try {
                    Runtime.getRuntime().exec(processUtils.getKillCommand(pid));
                    return true;
                }
                catch (Throwable t) {
                    ProcessLogger.ROOT_LOGGER.debugf(t, "failed to kill process '%s' with pid '%s'", (Object)processName, (Object)pid);
                }
            }
        }
        catch (Throwable t) {
            ProcessLogger.ROOT_LOGGER.debugf(t, "failed to resolve pid of process '%s'", (Object)processName);
        }
        return false;
    }

    protected String getJavaHome() {
        return WildFlySecurityManager.getPropertyPrivileged((String)"java.home", (String)".");
    }

    abstract String getJpsCommand();

    abstract String getKillCommand(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolveProcessId(String processName, int id) throws IOException {
        String jpsCommand = this.getJpsCommand();
        if (jpsCommand == null) {
            ProcessLogger.ROOT_LOGGER.jpsCommandNotFound(processName);
            return -1;
        }
        Process p = Runtime.getRuntime().exec(jpsCommand);
        ArrayList<String> processes = new ArrayList<String>();
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
        try {
            String line;
            String idParam;
            String process = "-D[" + processName + "]";
            String string = idParam = id < 0 ? null : "-D[pcid:" + id + "]";
            while ((line = input.readLine()) != null) {
                if (!line.contains(modulesJar) || !line.contains(process) || idParam != null && !line.contains(idParam)) continue;
                processes.add(line);
            }
        }
        finally {
            StreamUtils.safeClose(input);
        }
        if (processes.size() == 1) {
            String proc = (String)processes.get(0);
            int i = proc.indexOf(32);
            return Integer.parseInt(proc.substring(0, i));
        }
        if (processes.isEmpty()) {
            ProcessLogger.ROOT_LOGGER.processNotFound(processName);
        } else {
            ProcessLogger.ROOT_LOGGER.multipleProcessesFound(processName);
        }
        return -1;
    }

    private static class WindowsProcessUtils
    extends ProcessUtils {
        private WindowsProcessUtils() {
        }

        @Override
        String getJpsCommand() {
            File jreHome = new File(this.getJavaHome());
            File jpsExe = new File(jreHome, "bin/jps.exe");
            if (!jpsExe.exists()) {
                jpsExe = new File(jreHome, "../bin/jps.exe");
            }
            if (jpsExe.exists()) {
                return String.format("%s -vl", jpsExe.getAbsolutePath());
            }
            return null;
        }

        @Override
        String getKillCommand(int process) {
            return "taskkill /f /pid " + process;
        }
    }

    private static class UnixProcessUtils
    extends ProcessUtils {
        private UnixProcessUtils() {
        }

        @Override
        String getJpsCommand() {
            File jreHome = new File(this.getJavaHome());
            File jpsExe = new File(jreHome, "bin/jps");
            if (!jpsExe.exists()) {
                jpsExe = new File(jreHome, "../bin/jps");
            }
            if (jpsExe.exists()) {
                return String.format("%s -vl", jpsExe.getAbsolutePath());
            }
            return null;
        }

        @Override
        String getKillCommand(int process) {
            return "kill -9 " + process;
        }
    }
}

