/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.net.SocketFactory;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.as.process.protocol.Connection;
import org.jboss.as.process.protocol.ConnectionImpl;
import org.jboss.as.process.protocol.MessageHandler;
import org.wildfly.common.Assert;

public final class ProtocolClient {
    private final ThreadFactory threadFactory;
    private final SocketFactory socketFactory;
    private final InetSocketAddress serverAddress;
    private final MessageHandler messageHandler;
    private final InetSocketAddress bindAddress;
    private final int connectTimeout;
    private final int readTimeout;
    private final Executor readExecutor;
    private final Connection.ClosedCallback callback;

    public ProtocolClient(Configuration configuration) {
        this.threadFactory = configuration.getThreadFactory();
        this.bindAddress = configuration.getBindAddress();
        this.connectTimeout = configuration.getConnectTimeout();
        this.socketFactory = configuration.getSocketFactory();
        this.messageHandler = configuration.getMessageHandler();
        this.serverAddress = configuration.getServerAddress();
        this.readTimeout = configuration.getReadTimeout();
        this.readExecutor = configuration.getReadExecutor();
        this.callback = configuration.getClosedCallback();
        Assert.checkNotNullParam("threadFactory", this.threadFactory);
        Assert.checkNotNullParam("socketFactory", this.socketFactory);
        Assert.checkNotNullParam("serverAddress", this.serverAddress);
        Assert.checkNotNullParam("messageHandler", this.messageHandler);
        Assert.checkNotNullParam("readExecutor", this.readExecutor);
    }

    public Connection connect() throws IOException {
        ProcessLogger.PROTOCOL_CLIENT_LOGGER.tracef("Creating connection to %s", (Object)this.serverAddress);
        Socket socket = this.socketFactory.createSocket();
        ConnectionImpl connection = new ConnectionImpl(socket, this.messageHandler, this.readExecutor, this.callback);
        Thread thread = this.threadFactory.newThread(connection.getReadTask());
        if (thread == null) {
            throw ProcessLogger.ROOT_LOGGER.threadCreationRefused();
        }
        if (this.bindAddress != null) {
            socket.bind(this.bindAddress);
        }
        if (this.readTimeout != 0) {
            socket.setSoTimeout(this.readTimeout);
        }
        socket.connect(this.serverAddress, this.connectTimeout);
        thread.setName("Read thread for " + this.serverAddress);
        thread.start();
        ProcessLogger.PROTOCOL_CLIENT_LOGGER.tracef("Connected to %s", (Object)this.serverAddress);
        return connection;
    }

    public static final class Configuration {
        private ThreadFactory threadFactory;
        private SocketFactory socketFactory;
        private InetSocketAddress serverAddress;
        private MessageHandler messageHandler;
        private InetSocketAddress bindAddress;
        private Executor readExecutor;
        private int connectTimeout = 0;
        private int readTimeout = 0;
        private Connection.ClosedCallback closedCallback;

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public SocketFactory getSocketFactory() {
            return this.socketFactory;
        }

        public void setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
        }

        public InetSocketAddress getServerAddress() {
            return this.serverAddress;
        }

        public void setServerAddress(InetSocketAddress serverAddress) {
            this.serverAddress = serverAddress;
        }

        public MessageHandler getMessageHandler() {
            return this.messageHandler;
        }

        public void setMessageHandler(MessageHandler messageHandler) {
            this.messageHandler = messageHandler;
        }

        public InetSocketAddress getBindAddress() {
            return this.bindAddress;
        }

        public void setBindAddress(InetSocketAddress bindAddress) {
            this.bindAddress = bindAddress;
        }

        public Executor getReadExecutor() {
            return this.readExecutor;
        }

        public void setReadExecutor(Executor readExecutor) {
            this.readExecutor = readExecutor;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Connection.ClosedCallback getClosedCallback() {
            return this.closedCallback;
        }

        public void setClosedCallback(Connection.ClosedCallback closedCallback) {
            this.closedCallback = closedCallback;
        }
    }
}

