/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;
import org.wildfly.plugins.Insert;
import org.wildfly.plugins.RegisterOptions;
import org.wildfly.plugins.XmlConfigBuilder;

public class RegisterExtension {
    final Log log;

    public RegisterExtension(Log log) {
        this.log = log;
    }

    public void register(RegisterOptions options, File destFile, String moduleId) throws Exception {
        this.log.info((CharSequence)("Register extension module=" + moduleId));
        ArrayList<Insert> inserts = new ArrayList<Insert>();
        inserts.addAll(Arrays.asList(options.getInserts()));
        inserts.add(new Insert("/server/extensions", "<extension module=\"" + moduleId + "\"/>"));
        if (options.getSubsystem() != null) {
            inserts.add(new Insert("/server/profile", options.getSubsystem()));
        }
        if (options.getSocketBindingGroups() != null) {
            for (String group : options.getSocketBindingGroups()) {
                inserts.add(new Insert("/server/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
            }
        }
        new XmlConfigBuilder(this.log, options.getServerConfig(), destFile).inserts(inserts).build();
        this.log.info((CharSequence)("New serverConfig file written to [" + destFile.getAbsolutePath() + "]"));
    }
}

