/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.wildfly.plugins.Insert;
import org.wildfly.plugins.JBossModule;
import org.wildfly.plugins.RegisterExtension;
import org.wildfly.plugins.RegisterOptions;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.INSTALL)
public class DeployExtensionMojo
extends AbstractMojo {
    @Parameter
    private File moduleZip;
    @Parameter(defaultValue="${jboss.home}", required=true)
    private File jbossHome;
    @Parameter(defaultValue="")
    private String modulesHome;
    @Parameter(defaultValue="standalone/configuration/standalone.xml")
    private String serverConfig;
    @Parameter(defaultValue="standalone/configuration/standalone.xml.old")
    private String serverConfigBackup;
    @Parameter
    private File subsystem;
    @Parameter
    private File socketBinding;
    @Parameter
    private String[] socketBindingGroups = new String[]{"standard-sockets"};
    @Parameter
    private Insert[] edit;
    @Parameter
    private boolean failNoMatch;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    private File serverConfigAbsolute;
    private File serverConfigBackupAbsolute;
    private File modulesHomeAbsolute;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipDeploy) {
            this.getLog().info((CharSequence)"Skipped execution");
            return;
        }
        this.validConfiguration();
        JBossModule module = null;
        if (this.moduleZip != null) {
            try {
                module = JBossModule.readFromZipFile(this.getLog(), this.moduleZip);
            }
            catch (Exception e) {
                throw new MojoFailureException("Failed to read module : " + e.getMessage());
            }
            try {
                module.installTo(this.modulesHomeAbsolute);
            }
            catch (Exception e) {
                throw new MojoFailureException("Failed to install module : " + e.getMessage());
            }
        }
        try {
            RegisterOptions options = new RegisterOptions();
            if (module != null) {
                options.withExtension(module.getModuleId());
            }
            options.serverConfig(this.serverConfigAbsolute).serverConfigBackup(this.serverConfigBackupAbsolute).subsystem(this.subsystem).socketBinding(this.socketBinding).socketBindingGroups(this.socketBindingGroups).inserts(this.edit).failNoMatch(this.failNoMatch);
            this.register(options);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException("Failed to update server configuration file : " + e.getMessage());
        }
    }

    public void register(RegisterOptions options) throws Exception {
        File serverConfig = options.getServerConfig();
        this.getLog().info((CharSequence)("Backup original serverConfig [" + serverConfig.getAbsolutePath() + "] to [" + options.getServerConfigBackup().getAbsolutePath() + "]"));
        FileUtils.copyFile((File)serverConfig, (File)options.getServerConfigBackup());
        new RegisterExtension(this.getLog()).register(options);
    }

    private void validConfiguration() throws MojoFailureException {
        if (!(this.jbossHome.exists() && this.jbossHome.isDirectory() && this.jbossHome.canRead())) {
            throw new MojoFailureException("jbossHome = " + this.jbossHome.getAbsolutePath() + " is not readable and existing directory");
        }
        if (!new File(this.jbossHome, "modules").isDirectory()) {
            throw new MojoFailureException("jbossHome = " + this.jbossHome.getAbsolutePath() + " does not seem to point to AS7/WildFly installation dir");
        }
        this.serverConfigAbsolute = new File(this.serverConfig).isAbsolute() ? new File(this.serverConfig) : new File(this.jbossHome, this.serverConfig);
        if (!(this.serverConfigAbsolute.exists() && this.serverConfigAbsolute.isFile() && this.serverConfigAbsolute.canWrite())) {
            throw new MojoFailureException("serverConfig = " + this.serverConfig + " is not writable and existing file. [serverConfig] must be either absolute path or relative to [jbossHome]");
        }
        this.serverConfigBackupAbsolute = new File(this.serverConfigBackup).isAbsolute() ? new File(this.serverConfigBackup) : new File(this.jbossHome, this.serverConfigBackup);
        if (!(this.serverConfigBackupAbsolute.getParentFile().exists() && this.serverConfigAbsolute.getParentFile().isDirectory() && this.serverConfigAbsolute.getParentFile().canWrite())) {
            throw new MojoFailureException("serverConfigBackup = " + this.serverConfigBackup + " 's parent directory does not exist or is writable. [serverConfigBackup] must be either absolute path or relative to [jbossHome]");
        }
        if (this.modulesHome == null) {
            this.modulesHome = "";
        }
        this.modulesHomeAbsolute = new File(this.modulesHome).isAbsolute() ? new File(this.modulesHome) : new File(this.jbossHome, this.modulesHome);
        if (!(this.modulesHomeAbsolute.exists() && this.modulesHomeAbsolute.isDirectory() && this.modulesHomeAbsolute.canWrite())) {
            throw new MojoFailureException("modulesHome = " + this.modulesHome + " is not writable and existing directory. [modulesHome] must be either absolute path or relative to [jbossHome]");
        }
    }
}

