/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossModule {
    private final Log log;
    private File root;
    private String moduleId;
    private boolean isZip = false;
    private List<String> resources = new ArrayList<String>();

    private JBossModule(Log log) {
        this.log = log;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public static JBossModule readFromZipFile(Log log, File moduleZip) throws Exception {
        JBossModule m = new JBossModule(log);
        m.isZip = true;
        m.root = moduleZip;
        if (!moduleZip.canRead() || !moduleZip.isFile()) {
            throw new FileNotFoundException("File " + moduleZip.getAbsolutePath() + " does not exist");
        }
        ZipInputStream zin = null;
        BufferedInputStream bin = null;
        boolean moduleXmlFound = false;
        try {
            bin = new BufferedInputStream(new FileInputStream(moduleZip));
            zin = new ZipInputStream(bin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                if (!ze.getName().endsWith("main/module.xml")) continue;
                moduleXmlFound = true;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(zin);
                m.readModuleXmlInfo(doc);
                break;
            }
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (!moduleXmlFound) {
            throw new FileNotFoundException("module.xml was not found in " + moduleZip.getAbsolutePath());
        }
        return m;
    }

    private void readModuleXmlInfo(Document doc) throws Exception {
        this.moduleId = doc.getDocumentElement().getAttribute("name");
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile("//resources/resource-root").evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodeList.getLength()) {
            this.resources.add(nodeList.item(i).getAttributes().getNamedItem("path").getTextContent());
            ++i;
        }
    }

    public static JBossModule readFromDir(Log log, File rootDir) throws Exception {
        JBossModule m = new JBossModule(log);
        m.root = rootDir;
        File moduleFile = new File(rootDir, "module.xml");
        if (!moduleFile.exists() || !moduleFile.canRead()) {
            throw new FileNotFoundException("File " + moduleFile.getAbsolutePath() + " does not exist");
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(moduleFile);
        m.readModuleXmlInfo(doc);
        return m;
    }

    public List<File> installTo(File jbossHome) throws Exception {
        ArrayList<File> installedFiles = new ArrayList<File>();
        if (this.isZip) {
            ZipInputStream zin = null;
            this.log.info((CharSequence)("Extracting module [" + this.root.getAbsolutePath() + "] to [" + jbossHome.getAbsolutePath() + "]"));
            try {
                zin = new ZipInputStream(new FileInputStream(this.root));
                ZipEntry ze = null;
                while ((ze = zin.getNextEntry()) != null) {
                    String fileName = ze.getName();
                    File newFile = new File(jbossHome + File.separator + fileName);
                    if (ze.isDirectory()) continue;
                    this.log.debug((CharSequence)("Writing " + newFile.getAbsolutePath()));
                    File parent = newFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    IOUtil.copy((InputStream)zin, (OutputStream)fos);
                    IOUtil.close((OutputStream)fos);
                    installedFiles.add(newFile);
                }
            }
            finally {
                try {
                    if (zin != null) {
                        zin.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        File targetDir = new File(jbossHome, "modules" + File.separator + this.moduleId.replaceAll("\\.", File.separator) + File.separator + "main");
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new MojoFailureException("Failed to create module directory " + targetDir.getAbsolutePath());
        }
        File moduleFile = new File(this.root, "module.xml");
        for (String r : this.resources) {
            File resource = new File(this.root, r);
            if (!resource.canRead()) {
                throw new MojoFailureException("Resource file [" + r + "] referenced in [" + moduleFile.getAbsolutePath() + "] does not exist, fix ");
            }
            if (resource.isFile()) {
                FileUtils.copyFileToDirectory((File)resource, (File)targetDir);
                installedFiles.add(resource);
                continue;
            }
            if (!resource.isDirectory()) continue;
            FileUtils.copyDirectoryStructure((File)resource, (File)targetDir);
        }
        FileUtils.copyFileToDirectory((File)moduleFile, (File)targetDir);
        return installedFiles;
    }
}

