/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;
import org.wildfly.plugins.Insert;
import org.wildfly.plugins.RegisterOptions;
import org.wildfly.plugins.XmlConfigBuilder;

public class RegisterExtension {
    final Log log;

    public RegisterExtension(Log log) {
        this.log = log;
    }

    public void register(RegisterOptions options) throws Exception {
        ArrayList<Insert> inserts = new ArrayList<Insert>();
        inserts.addAll(Arrays.asList(options.getInserts()));
        if (options.getModuleId() != null) {
            this.log.info((CharSequence)("Register extension module=" + options.getModuleId()));
            inserts.add(new Insert("/server/extensions", "<extension module=\"" + options.getModuleId() + "\"/>"));
        }
        if (options.getSubsystem() != null) {
            inserts.add(new Insert("/server/profile", options.getSubsystem()));
        }
        if (options.getSocketBindingGroups() != null && options.getSocketBinding() != null) {
            String[] stringArray = options.getSocketBindingGroups();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                inserts.add(new Insert("/server/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
                ++n2;
            }
        }
        new XmlConfigBuilder(this.log, options.getServerConfigBackup(), options.getServerConfig()).inserts(inserts).failNoMatch(options.isFailNoMatch()).build();
        this.log.info((CharSequence)("New serverConfig file written to [" + options.getServerConfig().getAbsolutePath() + "]"));
    }
}

