/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.plugin.core.Assertions;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentDescription;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentOperations;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.core.SimpleDeploymentDescription;
import org.wildfly.plugin.core.UndeployDescription;

class DefaultDeploymentManager
implements DeploymentManager {
    private final ModelControllerClient client;
    private final LazyDomainCheck domainCheck = new LazyDomainCheck();

    DefaultDeploymentManager(ModelControllerClient client) {
        this.client = client;
    }

    @Override
    public DeploymentResult deploy(Deployment deployment) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(deployment);
        if (failedResult != null) {
            return failedResult;
        }
        return this.execute(DeploymentOperations.createDeployOperation(deployment));
    }

    @Override
    public DeploymentResult deploy(Set<Deployment> deployments) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(deployments);
        if (failedResult != null) {
            return failedResult;
        }
        return this.execute(DeploymentOperations.createDeployOperation(deployments));
    }

    @Override
    public DeploymentResult forceDeploy(Deployment deployment) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(deployment);
        if (failedResult != null) {
            return failedResult;
        }
        if (this.hasDeployment(deployment.getName())) {
            if (this.isDomain()) {
                DeploymentDescription current = this.getServerGroupDeployment(deployment.getName());
                Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
                DeploymentOperations.addReplaceOperationSteps(builder, deployment, current, true);
                return this.execute(builder.build());
            }
            return this.redeploy(deployment);
        }
        return this.deploy(deployment);
    }

    @Override
    public DeploymentResult forceDeploy(Set<Deployment> deployments) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(deployments);
        if (failedResult != null) {
            return failedResult;
        }
        LinkedHashSet<Deployment> toDeploy = new LinkedHashSet<Deployment>();
        LinkedHashMap<Deployment, DeploymentDescription> toRedeploy = new LinkedHashMap<Deployment, DeploymentDescription>();
        Set<DeploymentDescription> currentDeployments = this.getDeployments();
        for (Deployment deployment : deployments) {
            DeploymentDescription currentDeployment = DefaultDeploymentManager.findDeployment(currentDeployments, deployment);
            if (currentDeployment != null) {
                toRedeploy.put(deployment, currentDeployment);
                continue;
            }
            toDeploy.add(deployment);
        }
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create((boolean)true);
        for (Deployment deployment : toDeploy) {
            DeploymentOperations.addDeployOperationStep(builder, deployment);
        }
        for (Deployment deployment : toRedeploy.keySet()) {
            if (this.isDomain()) {
                DeploymentOperations.addReplaceOperationSteps(builder, deployment, (DeploymentDescription)toRedeploy.get(deployment), true);
                continue;
            }
            DeploymentOperations.addReplaceOperationSteps(builder, deployment);
        }
        return this.execute(builder.build());
    }

    @Override
    public DeploymentResult redeploy(Deployment deployment) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(deployment);
        if (failedResult != null) {
            return failedResult;
        }
        return this.execute(DeploymentOperations.createReplaceOperation(deployment));
    }

    @Override
    public DeploymentResult redeploy(Set<Deployment> deployments) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(deployments);
        if (failedResult != null) {
            return failedResult;
        }
        return this.execute(DeploymentOperations.createReplaceOperation(deployments));
    }

    @Override
    public DeploymentResult undeploy(UndeployDescription undeployDescription) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(undeployDescription);
        if (failedResult != null) {
            return failedResult;
        }
        return this.execute(DeploymentOperations.createUndeployOperation(undeployDescription));
    }

    @Override
    public DeploymentResult undeploy(Set<UndeployDescription> undeployDescriptions) throws IOException {
        DeploymentResult failedResult = this.validateDeployment(undeployDescriptions);
        if (failedResult != null) {
            return failedResult;
        }
        return this.execute(DeploymentOperations.createUndeployOperation(undeployDescriptions));
    }

    @Override
    public Set<DeploymentDescription> getDeployments() throws IOException {
        ModelNode readDeployments = Operations.createOperation((String)"read-children-names");
        readDeployments.get("child-type").set("deployment");
        if (this.isDomain()) {
            LinkedHashMap serverGroupDeployments = new LinkedHashMap();
            Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
            builder.addStep(readDeployments);
            ModelNode address = DeploymentOperations.createAddress("server-group", "*", "deployment", "*");
            builder.addStep(Operations.createReadResourceOperation((ModelNode)address));
            ModelNode result = this.client.execute(builder.build());
            if (Operations.isSuccessfulOutcome((ModelNode)result)) {
                ModelNode results = Operations.readResult((ModelNode)result);
                for (ModelNode r : Operations.readResult((ModelNode)results.get("step-1")).asList()) {
                    serverGroupDeployments.put(r.asString(), new LinkedHashSet());
                }
                for (ModelNode r : Operations.readResult((ModelNode)results.get("step-2")).asList()) {
                    List resultAddress = Operations.getOperationAddress((ModelNode)r).asPropertyList();
                    String serverGroup = null;
                    String deployment = null;
                    for (Property property : resultAddress) {
                        if ("server-group".equals(property.getName())) {
                            serverGroup = property.getValue().asString();
                            continue;
                        }
                        if (!"deployment".equals(property.getName())) continue;
                        deployment = property.getValue().asString();
                    }
                    Set serverGroups = (Set)serverGroupDeployments.get(deployment);
                    serverGroups.add(serverGroup);
                }
                LinkedHashSet<DeploymentDescription> deployments = new LinkedHashSet<DeploymentDescription>();
                for (Map.Entry entry : serverGroupDeployments.entrySet()) {
                    String name = (String)entry.getKey();
                    Set<String> serverGroups = Collections.unmodifiableSet((Set)entry.getValue());
                    deployments.add(SimpleDeploymentDescription.of(name, serverGroups));
                }
                return deployments;
            }
            throw new RuntimeException("Failed to get listing of deployments. Reason: " + Operations.getFailureDescription((ModelNode)result).asString());
        }
        LinkedHashSet<DeploymentDescription> deployments = new LinkedHashSet<DeploymentDescription>();
        ModelNode result = this.client.execute(readDeployments);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            for (ModelNode deployment : Operations.readResult((ModelNode)result).asList()) {
                String deploymentName = deployment.asString();
                deployments.add(SimpleDeploymentDescription.of(deploymentName));
            }
            return deployments;
        }
        throw new RuntimeException("Failed to get listing of deployments. Reason: " + Operations.getFailureDescription((ModelNode)result).asString());
    }

    @Override
    public Set<DeploymentDescription> getDeployments(String serverGroup) throws IOException {
        if (!this.isDomain()) {
            throw new IllegalStateException("Server is not a managed domain. Running container: " + ServerHelper.getContainerDescription(this.client));
        }
        LinkedHashSet<DeploymentDescription> deployments = new LinkedHashSet<DeploymentDescription>();
        for (DeploymentDescription deployment : this.getDeployments()) {
            Set<String> serverGroups = Collections.unmodifiableSet(deployment.getServerGroups());
            if (!serverGroups.contains(serverGroup)) continue;
            deployments.add(deployment);
        }
        return deployments;
    }

    @Override
    public Set<String> getDeploymentNames() throws IOException {
        ModelNode readDeployments = Operations.createOperation((String)"read-children-names");
        readDeployments.get("child-type").set("deployment");
        LinkedHashSet<String> deployments = new LinkedHashSet<String>();
        ModelNode result = this.client.execute(readDeployments);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            for (ModelNode deployment : Operations.readResult((ModelNode)result).asList()) {
                String deploymentName = deployment.asString();
                deployments.add(deploymentName);
            }
            return deployments;
        }
        throw new RuntimeException("Failed to get listing of deployments. Reason: " + Operations.getFailureDescription((ModelNode)result).asString());
    }

    @Override
    public boolean hasDeployment(String name) throws IOException {
        return this.hasDeployment(DeploymentOperations.EMPTY_ADDRESS, name);
    }

    @Override
    public boolean hasDeployment(String name, String serverGroup) {
        ModelNode address = DeploymentOperations.createAddress("server-group", serverGroup);
        return this.hasDeployment(address, name);
    }

    private boolean hasDeployment(ModelNode address, String name) {
        block4: {
            ModelNode op = Operations.createOperation((String)"read-children-names", (ModelNode)address);
            op.get("child-type").set("deployment");
            try {
                ModelNode listDeploymentsResult = this.client.execute(op);
                if (Operations.isSuccessfulOutcome((ModelNode)listDeploymentsResult)) {
                    List deployments = Operations.readResult((ModelNode)listDeploymentsResult).asList();
                    for (ModelNode deployment : deployments) {
                        if (!name.equals(deployment.asString())) continue;
                        return true;
                    }
                    break block4;
                }
                throw new IllegalStateException(Operations.getFailureDescription((ModelNode)listDeploymentsResult).asString());
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not execute operation '%s'", op), e);
            }
        }
        return false;
    }

    private DeploymentResult execute(Operation op) throws IOException {
        ModelNode result = this.client.execute(op);
        return new DeploymentResult(result);
    }

    private DeploymentDescription getServerGroupDeployment(String name) throws IOException {
        LinkedHashSet<String> serverGroups = new LinkedHashSet<String>();
        ModelNode address = DeploymentOperations.createAddress("server-group", "*", "deployment", name);
        ModelNode result = this.client.execute(Operations.createReadResourceOperation((ModelNode)address));
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            for (ModelNode r : Operations.readResult((ModelNode)result).asList()) {
                List resultAddress = Operations.getOperationAddress((ModelNode)r).asPropertyList();
                String foundServerGroup = null;
                for (Property property : resultAddress) {
                    if (!"server-group".equals(property.getName())) continue;
                    foundServerGroup = property.getValue().asString();
                }
                serverGroups.add(foundServerGroup);
            }
            return SimpleDeploymentDescription.of(name, Collections.unmodifiableSet(serverGroups));
        }
        throw new RuntimeException("Failed to get listing of deployments. Reason: " + Operations.getFailureDescription((ModelNode)result).asString());
    }

    private DeploymentResult validateDeployment(DeploymentDescription deployment) throws IOException {
        Assertions.requiresNotNullParameter(deployment, "deployment");
        Set<String> serverGroups = deployment.getServerGroups();
        if (this.isDomain() && serverGroups.isEmpty()) {
            return new DeploymentResult("No server groups were defined for the deployment operation. Deployment: %s", deployment);
        }
        if (!this.isDomain() && !serverGroups.isEmpty()) {
            return new DeploymentResult("Server is not a managed domain, but server groups were defined. Deployment: %s", deployment);
        }
        return null;
    }

    private DeploymentResult validateDeployment(Set<? extends DeploymentDescription> deployments) throws IOException {
        Assertions.requiresNotNullParameter(deployments, "deployments");
        LinkedHashSet<DeploymentDescription> missingServerGroups = new LinkedHashSet<DeploymentDescription>();
        LinkedHashSet<DeploymentDescription> standaloneWithServerGroups = new LinkedHashSet<DeploymentDescription>();
        boolean error = false;
        for (DeploymentDescription deploymentDescription : deployments) {
            Set<String> serverGroups = deploymentDescription.getServerGroups();
            if (this.isDomain() && serverGroups.isEmpty()) {
                error = true;
                missingServerGroups.add(deploymentDescription);
                continue;
            }
            if (this.isDomain() || serverGroups.isEmpty()) continue;
            error = true;
            standaloneWithServerGroups.add(deploymentDescription);
        }
        if (error) {
            StringBuilder message = new StringBuilder();
            if (!missingServerGroups.isEmpty()) {
                message.append("No server groups were defined on the following deployments: ").append(missingServerGroups);
            }
            if (!standaloneWithServerGroups.isEmpty()) {
                message.append("Server is not a managed domain but the following deployments had server groups defined: ").append(standaloneWithServerGroups);
            }
            return new DeploymentResult(message);
        }
        return null;
    }

    private boolean isDomain() throws IOException {
        return this.domainCheck.get();
    }

    private static DeploymentDescription findDeployment(Iterable<DeploymentDescription> deployments, DeploymentDescription deployment) {
        for (DeploymentDescription deploymentDescription : deployments) {
            if (!deploymentDescription.getName().equals(deployment.getName())) continue;
            return deploymentDescription;
        }
        return null;
    }

    private class LazyDomainCheck {
        private final AtomicBoolean set = new AtomicBoolean(false);
        private Boolean value = null;

        private LazyDomainCheck() {
        }

        public boolean get() throws IOException {
            while (this.value == null) {
                if (!this.set.compareAndSet(false, true)) continue;
                this.value = ServerHelper.isDomainServer(DefaultDeploymentManager.this.client);
            }
            return this.value;
        }
    }
}

