/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.wildfly.plugin.core.Assertions;
import org.wildfly.plugin.core.DeploymentDescription;

class SimpleDeploymentDescription
implements DeploymentDescription {
    private final String name;
    private final Set<String> serverGroups;

    private SimpleDeploymentDescription(String name, Set<String> serverGroups) {
        this.name = name;
        this.serverGroups = serverGroups;
    }

    static SimpleDeploymentDescription of(String name) {
        return new SimpleDeploymentDescription(Assertions.requiresNotNullParameter(name, "name"), Collections.emptySet());
    }

    static SimpleDeploymentDescription of(String name, Set<String> serverGroups) {
        return new SimpleDeploymentDescription(Assertions.requiresNotNullParameter(name, "name"), Assertions.requiresNotNullParameter(serverGroups, "serverGroups"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getServerGroups() {
        return this.serverGroups;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleDeploymentDescription)) {
            return false;
        }
        SimpleDeploymentDescription other = (SimpleDeploymentDescription)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        StringBuilder result = new StringBuilder(SimpleDeploymentDescription.class.getSimpleName());
        result.append('(');
        result.append("name=").append(this.getName());
        if (!this.serverGroups.isEmpty()) {
            result.append(", serverGroups=").append(this.serverGroups);
        }
        return result.append(')').toString();
    }

    @Override
    public int compareTo(DeploymentDescription o) {
        return this.getName().compareTo(o.getName());
    }
}

