/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.wildfly.plugin.core.Assertions;
import org.wildfly.plugin.core.DeploymentDescription;

public class UndeployDescription
implements DeploymentDescription {
    private final String name;
    private final Set<String> serverGroups;
    private boolean failOnMissing;

    public UndeployDescription(String name) {
        this.name = Assertions.requiresNotNullParameter(name, "name");
        this.serverGroups = new LinkedHashSet<String>();
    }

    public static UndeployDescription of(String name) {
        return new UndeployDescription(name);
    }

    public static UndeployDescription of(DeploymentDescription deploymentDescription) {
        return UndeployDescription.of(deploymentDescription.getName()).addServerGroups(deploymentDescription.getServerGroups());
    }

    public UndeployDescription addServerGroup(String serverGroup) {
        this.serverGroups.add(serverGroup);
        return this;
    }

    public UndeployDescription addServerGroups(String ... serverGroups) {
        return this.addServerGroups(Arrays.asList(serverGroups));
    }

    public UndeployDescription addServerGroups(Collection<String> serverGroups) {
        this.serverGroups.addAll(serverGroups);
        return this;
    }

    @Override
    public Set<String> getServerGroups() {
        return new LinkedHashSet<String>(this.serverGroups);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isFailOnMissing() {
        return this.failOnMissing;
    }

    public UndeployDescription setFailOnMissing(boolean failOnMissing) {
        this.failOnMissing = failOnMissing;
        return this;
    }

    @Override
    public int compareTo(DeploymentDescription o) {
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UndeployDescription)) {
            return false;
        }
        UndeployDescription other = (UndeployDescription)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        StringBuilder result = new StringBuilder(UndeployDescription.class.getSimpleName());
        result.append('(');
        result.append("name=").append(this.getName());
        result.append(", failOnMissing=").append(this.failOnMissing);
        if (!this.serverGroups.isEmpty()) {
            result.append(", serverGroups=").append(this.serverGroups);
        }
        return result.append(')').toString();
    }
}

