/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.plugin.core.ConfigurationId;
import org.wildfly.plugin.core.FeaturePack;

public class GalleonUtils {
    private static final String WILDFLY_DEFAULT_FEATURE_PACK_LOCATION = "wildfly@maven(org.jboss.universe:community-universe)";

    public static void provision(Path jbossHome, String version, MavenRepoManager artifactResolver) throws ProvisioningException {
        try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)artifactResolver)).setInstallationHome(jbossHome).build();){
            pm.provision(GalleonUtils.buildDefaultConfig(version));
        }
    }

    public static ProvisioningConfig buildDefaultConfig() throws ProvisioningDescriptionException {
        return GalleonUtils.buildDefaultConfig(null);
    }

    public static ProvisioningConfig buildDefaultConfig(String version) throws ProvisioningDescriptionException {
        String location = GalleonUtils.getWildFlyFeaturePackLocation(version);
        ProvisioningConfig.Builder state = ProvisioningConfig.builder();
        FeaturePackLocation fpl = FeaturePackLocation.fromString((String)location);
        FeaturePackConfig.Builder fpConfig = FeaturePackConfig.builder((FeaturePackLocation)fpl);
        fpConfig.setInheritConfigs(true);
        fpConfig.setInheritPackages(true);
        state.addFeaturePackDep(fpConfig.build());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("jboss-fork-embedded", "true");
        state.addOptions(options);
        return state.build();
    }

    public static ProvisioningConfig buildConfig(Path provisioningFile) throws ProvisioningException {
        return ProvisioningXmlParser.parse((Path)provisioningFile);
    }

    public static ProvisioningConfig buildConfig(ProvisioningManager pm, List<FeaturePack> featurePacks, List<String> layers, List<String> excludedLayers, Map<String, String> pluginOptions, String layersConfigFileName) throws ProvisioningException, IllegalArgumentException {
        ProvisioningConfig.Builder state = ProvisioningConfig.builder();
        boolean hasLayers = !layers.isEmpty();
        boolean fpWithDefaults = true;
        if (!hasLayers) {
            for (FeaturePack fp : featurePacks) {
                if (fp.isInheritConfigs() == null && fp.isInheritPackages() == null && fp.getIncludedConfigs().isEmpty() && fp.getExcludedConfigs().isEmpty() && !fp.isTransitive() && fp.getExcludedPackages().isEmpty() && fp.getIncludedPackages().isEmpty()) continue;
                fpWithDefaults = false;
                break;
            }
        }
        for (FeaturePack fp : featurePacks) {
            FeaturePackConfig.Builder fpConfig;
            FeaturePackLocation fpl;
            if (fp.getLocation() == null && (fp.getGroupId() == null || fp.getArtifactId() == null) && fp.getNormalizedPath() == null) {
                throw new IllegalArgumentException("Feature-pack location, Maven GAV or feature pack path is missing");
            }
            if (fp.getNormalizedPath() != null) {
                fpl = pm.getLayoutFactory().addLocal(fp.getNormalizedPath(), false);
            } else if (fp.getGroupId() != null && fp.getArtifactId() != null) {
                String coords = GalleonUtils.getMavenCoords(fp);
                fpl = FeaturePackLocation.fromString((String)coords);
            } else {
                long numSeparators;
                Object location = fp.getLocation();
                if (!FeaturePackLocation.fromString((String)location).hasUniverse() && (numSeparators = ((String)location).chars().filter(ch -> ch == 58).count()) <= 1L) {
                    location = (String)location + ":";
                }
                fpl = FeaturePackLocation.fromString((String)location);
            }
            FeaturePackConfig.Builder builder = fpConfig = fp.isTransitive() ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl) : FeaturePackConfig.builder((FeaturePackLocation)fpl);
            if (fp.isInheritConfigs() == null) {
                if (hasLayers) {
                    fpConfig.setInheritConfigs(false);
                } else if (fpWithDefaults) {
                    fpConfig.setInheritConfigs(true);
                }
            } else {
                fpConfig.setInheritConfigs(fp.isInheritConfigs().booleanValue());
            }
            if (fp.isInheritPackages() == null) {
                if (hasLayers) {
                    fpConfig.setInheritPackages(false);
                } else if (fpWithDefaults) {
                    fpConfig.setInheritConfigs(true);
                }
            } else {
                fpConfig.setInheritPackages(fp.isInheritPackages().booleanValue());
            }
            if (!fp.getExcludedConfigs().isEmpty()) {
                for (ConfigurationId configId : fp.getExcludedConfigs()) {
                    if (configId.isModelOnly()) {
                        fpConfig.excludeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfig.excludeDefaultConfig(configId.getId());
                }
            }
            if (!fp.getIncludedConfigs().isEmpty()) {
                for (ConfigurationId configId : fp.getIncludedConfigs()) {
                    if (configId.isModelOnly()) {
                        fpConfig.includeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfig.includeDefaultConfig(configId.getId());
                }
            }
            if (!fp.getIncludedPackages().isEmpty()) {
                for (String includedPackage : fp.getIncludedPackages()) {
                    fpConfig.includePackage(includedPackage);
                }
            }
            if (!fp.getExcludedPackages().isEmpty()) {
                for (String excludedPackage : fp.getExcludedPackages()) {
                    fpConfig.excludePackage(excludedPackage);
                }
            }
            state.addFeaturePackDep(fpConfig.build());
        }
        if (!layers.isEmpty()) {
            ConfigModel.Builder configBuilder = ConfigModel.builder((String)"standalone", (String)layersConfigFileName);
            for (String layer : layers) {
                configBuilder.includeLayer(layer);
            }
            for (String layer : excludedLayers) {
                configBuilder.excludeLayer(layer);
            }
            state.addConfig(configBuilder.build());
            if (pluginOptions.isEmpty()) {
                pluginOptions = Collections.singletonMap("optional-packages", "passive+");
            } else if (!pluginOptions.containsKey("optional-packages")) {
                pluginOptions.put("optional-packages", "passive+");
            }
        }
        state.addOptions(pluginOptions);
        return state.build();
    }

    private static String getMavenCoords(FeaturePack fp) {
        String type;
        StringBuilder builder = new StringBuilder();
        builder.append(fp.getGroupId()).append(":").append(fp.getArtifactId());
        String string = type = fp.getExtension() == null ? fp.getType() : fp.getExtension();
        if (fp.getClassifier() != null || type != null) {
            builder.append(":").append(fp.getClassifier() == null ? "" : fp.getClassifier()).append(":").append(type == null ? "" : type);
        }
        if (fp.getVersion() != null) {
            builder.append(":").append(fp.getVersion());
        }
        return builder.toString();
    }

    private static String getWildFlyFeaturePackLocation(String version) {
        StringBuilder fplBuilder = new StringBuilder();
        fplBuilder.append(WILDFLY_DEFAULT_FEATURE_PACK_LOCATION);
        if (version != null) {
            fplBuilder.append("#").append(version);
        }
        return fplBuilder.toString();
    }
}

