/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.text.MessageFormat;
import org.apache.maven.plugin.logging.Log;
import org.jboss.logging.Logger;

public class MavenJBossLogger
extends Logger {
    private final Log mavenLogger;

    public MavenJBossLogger(Log mavenLogger) {
        super(mavenLogger.toString());
        this.mavenLogger = mavenLogger;
    }

    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        String msg = parameters == null ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters);
        this.doMavenLog(level, msg, thrown);
    }

    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        String msg = String.format(format, parameters);
        this.doMavenLog(level, msg, thrown);
    }

    public boolean isEnabled(Logger.Level level) {
        switch (level) {
            case DEBUG: {
                return this.mavenLogger.isDebugEnabled();
            }
            case INFO: {
                return this.mavenLogger.isInfoEnabled();
            }
            case WARN: {
                return this.mavenLogger.isWarnEnabled();
            }
            case FATAL: 
            case ERROR: {
                return this.mavenLogger.isErrorEnabled();
            }
        }
        return false;
    }

    private void doMavenLog(Logger.Level level, String msg, Throwable thrown) {
        switch (level) {
            case DEBUG: 
            case TRACE: {
                if (thrown == null) {
                    this.mavenLogger.debug((CharSequence)msg);
                    break;
                }
                this.mavenLogger.debug((CharSequence)msg, thrown);
                break;
            }
            case WARN: {
                if (thrown == null) {
                    this.mavenLogger.warn((CharSequence)msg);
                    break;
                }
                this.mavenLogger.warn((CharSequence)msg, thrown);
                break;
            }
            case FATAL: 
            case ERROR: {
                if (thrown == null) {
                    this.mavenLogger.error((CharSequence)msg);
                    break;
                }
                this.mavenLogger.error((CharSequence)msg, thrown);
                break;
            }
            default: {
                if (thrown == null) {
                    this.mavenLogger.info((CharSequence)msg);
                    break;
                }
                this.mavenLogger.info((CharSequence)msg, thrown);
            }
        }
    }
}

