/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.bootablejar;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonFeaturePackRuntime;
import org.jboss.galleon.api.GalleonProvisioningRuntime;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.common.Assert;
import org.wildfly.plugin.tools.bootablejar.ScannedArtifacts;
import org.wildfly.plugin.tools.cli.CLIForkedBootConfigGenerator;
import org.wildfly.plugin.tools.cli.ForkedCLIUtil;
import org.wildfly.plugin.tools.util.Assertions;

public class BootableJarSupport {
    public static final String BOOTABLE_SUFFIX = "bootable";
    public static final String JBOSS_MODULES_GROUP_ID = "org.jboss.modules";
    public static final String JBOSS_MODULES_ARTIFACT_ID = "jboss-modules";
    private static final String MODULE_ID_JAR_RUNTIME = "org.wildfly.bootable-jar";
    private static final String BOOT_ARTIFACT_ID = "wildfly-jar-boot";
    public static final String WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH = "wildfly/artifact-versions.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packageBootableJar(Path targetJarFile, Path workDir, GalleonProvisioningConfig config, Path serverHome, MavenRepoManager resolver, MessageWriter writer) throws IOException, ProvisioningException {
        Path contentRootDir = workDir.resolve("bootable-jar-build-artifacts");
        if (Files.exists(contentRootDir, new LinkOption[0])) {
            IoUtils.recursiveDelete((Path)contentRootDir);
        }
        Files.createDirectories(contentRootDir, new FileAttribute[0]);
        try {
            ScannedArtifacts bootable;
            Path emptyHome = contentRootDir.resolve("tmp-home");
            Files.createDirectories(emptyHome, new FileAttribute[0]);
            try (Provisioning pm = ((GalleonBuilder)new GalleonBuilder().addArtifactResolver((RepositoryArtifactResolver)resolver)).newProvisioningBuilder(config).setInstallationHome(emptyHome).setMessageWriter(writer).build();){
                bootable = BootableJarSupport.scanArtifacts(pm, config, writer);
                pm.storeProvisioningConfig(config, contentRootDir.resolve("provisioning.xml"));
            }
            ArrayList<String> paths = new ArrayList<String>();
            for (MavenArtifact a : bootable.getCliArtifacts()) {
                resolver.resolve(a);
                paths.add(a.getPath().toAbsolutePath().toString());
            }
            Path output = File.createTempFile("cli-script-output", null).toPath();
            Files.deleteIfExists(output);
            IoUtils.recursiveDelete((Path)emptyHome);
            try {
                ForkedCLIUtil.fork(paths, CLIForkedBootConfigGenerator.class, serverHome, output, new String[0]);
            }
            finally {
                Files.deleteIfExists(output);
            }
            BootableJarSupport.zipServer(serverHome, contentRootDir);
            BootableJarSupport.buildJar(contentRootDir, targetJarFile, bootable, resolver);
        }
        finally {
            IoUtils.recursiveDelete((Path)contentRootDir);
        }
    }

    public static void unzipCloudExtension(Path contentDir, String version, MavenRepoManager resolver) throws MavenUniverseException, IOException {
        MavenArtifact ma = new MavenArtifact();
        ma.setGroupId("org.wildfly.plugins");
        ma.setArtifactId("wildfly-jar-cloud-extension");
        ma.setExtension("jar");
        ma.setVersion(Assertions.requiresNotNullOrNotEmptyParameter("version", version));
        resolver.resolve(ma);
        ZipUtils.unzip((Path)ma.getPath(), (Path)((Path)Assert.checkNotNullParam((String)"contentDir", (Object)contentDir)));
    }

    public static void zipServer(Path source, Path targetDir) throws IOException {
        BootableJarSupport.zipServer(source, targetDir, "wildfly.zip");
    }

    public static void zipServer(Path source, Path targetDir, String zipFileName) throws IOException {
        BootableJarSupport.cleanupServer((Path)Assert.checkNotNullParam((String)"source", (Object)source));
        Path target = ((Path)Assert.checkNotNullParam((String)"targetDir", (Object)targetDir)).resolve(Assertions.requiresNotNullOrNotEmptyParameter("zipFileName", zipFileName));
        ZipUtils.zip((Path)source, (Path)target);
    }

    public static ScannedArtifacts scanArtifacts(Provisioning pm, GalleonProvisioningConfig config, MessageWriter writer) throws ProvisioningException {
        HashSet<MavenArtifact> cliArtifacts = new HashSet<MavenArtifact>();
        MavenArtifact jbossModules = null;
        MavenArtifact bootArtifact = null;
        try (GalleonProvisioningRuntime rt = pm.getProvisioningRuntime(config);){
            for (GalleonFeaturePackRuntime fprt : rt.getGalleonFeaturePacks()) {
                MavenArtifact a;
                String value;
                HashMap<String, String> propsMap;
                Path artifactProps;
                if (fprt.getGalleonPackage(MODULE_ID_JAR_RUNTIME) != null) {
                    artifactProps = fprt.getResource(new String[]{WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH});
                    propsMap = new HashMap<String, String>();
                    try {
                        BootableJarSupport.readProperties(artifactProps, propsMap);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Error reading artifact versions", ex);
                    }
                    for (Map.Entry entry : propsMap.entrySet()) {
                        value = (String)entry.getValue();
                        a = BootableJarSupport.parseArtifact(value);
                        if (!BOOT_ARTIFACT_ID.equals(a.getArtifactId())) continue;
                        if (writer.isVerboseEnabled()) {
                            writer.verbose("Found %s in %s", new Object[]{a, fprt.getFPID()});
                        }
                        bootArtifact = a;
                        break;
                    }
                }
                artifactProps = fprt.getResource(new String[]{WILDFLY_ARTIFACT_VERSIONS_RESOURCE_PATH});
                propsMap = new HashMap();
                try {
                    BootableJarSupport.readProperties(artifactProps, propsMap);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error reading artifact versions", ex);
                }
                for (Map.Entry entry : propsMap.entrySet()) {
                    value = (String)entry.getValue();
                    a = BootableJarSupport.parseArtifact(value);
                    if ("wildfly-cli".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        a.setClassifier("client");
                        if (writer.isVerboseEnabled()) {
                            writer.verbose("Found %s in %s", new Object[]{a, fprt.getFPID()});
                        }
                        cliArtifacts.add(a);
                        continue;
                    }
                    if (!JBOSS_MODULES_ARTIFACT_ID.equals(a.getArtifactId()) || !JBOSS_MODULES_GROUP_ID.equals(a.getGroupId())) continue;
                    jbossModules = a;
                }
            }
        }
        if (bootArtifact == null) {
            throw new ProvisioningException("Server doesn't support bootable jar packaging");
        }
        if (jbossModules == null) {
            throw new ProvisioningException("JBoss Modules not found in dependency, can't create a Bootable JAR");
        }
        return new ScannedArtifacts(bootArtifact, jbossModules, cliArtifacts);
    }

    public static void buildJar(Path contentDir, Path jarFile, ScannedArtifacts bootable, MavenRepoManager resolver) throws IOException, MavenUniverseException {
        resolver.resolve(bootable.getBoot());
        Path rtJarFile = bootable.getBoot().getPath();
        resolver.resolve(bootable.getJbossModules());
        Path jbossModulesFile = bootable.getJbossModules().getPath();
        ZipUtils.unzip((Path)jbossModulesFile, (Path)contentDir);
        ZipUtils.unzip((Path)rtJarFile, (Path)contentDir);
        ZipUtils.zip((Path)contentDir, (Path)jarFile);
    }

    private static void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        Files.deleteIfExists(jbossHome.resolve("README.txt"));
    }

    private static void readProperties(Path propsFile, Map<String, String> propsMap) {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#') {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new RuntimeException("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static MavenArtifact parseArtifact(String artifact) {
        String[] parts = artifact.split(":");
        if (parts.length < 5) {
            throw new IllegalArgumentException("Failed to parse artifact " + artifact);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String classifier = parts[3];
        String extension = parts[4];
        MavenArtifact ma = new MavenArtifact();
        ma.setGroupId(groupId);
        ma.setArtifactId(artifactId);
        ma.setVersion(version);
        ma.setClassifier(classifier);
        ma.setExtension(extension);
        return ma;
    }
}

