/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.cli;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.logging.Logger;

public class ForkedCLIUtil {
    private static final Logger LOGGER = Logger.getLogger(ForkedCLIUtil.class);
    private static final Path JAVA_HOME;
    private static final String JAVA_CMD;

    public static void fork(String[] artifacts, Class<?> clazz, Path home, Path output, String ... args) throws IOException {
        ForkedCLIUtil.fork(List.of(artifacts), clazz, home, output, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fork(Collection<String> artifacts, Class<?> clazz, Path home, Path output, String ... args) throws IOException {
        StringBuilder cp = new StringBuilder();
        for (String loc : artifacts) {
            cp.append(loc).append(File.pathSeparator);
        }
        StringBuilder contextCP = new StringBuilder();
        ForkedCLIUtil.collectCpUrls(Thread.currentThread().getContextClassLoader(), contextCP);
        if (contextCP.length() == 0) {
            LOGGER.debug((Object)"Re-using process classpath to retrieve Maven plugin classes to fork CLI process.");
            cp.append(System.getProperty("java.class.path"));
        } else {
            cp.append((CharSequence)contextCP);
        }
        Path properties = ForkedCLIUtil.storeSystemProps();
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(JAVA_CMD);
        argsList.add("-server");
        argsList.add("-cp");
        argsList.add(cp.toString());
        argsList.add(clazz.getName());
        argsList.add(home.toString());
        argsList.add(output.toString());
        argsList.add(properties.toString());
        argsList.addAll(List.of(args));
        LOGGER.debugf("CLI process command line %s", argsList);
        try {
            int exitCode;
            Process p = new ProcessBuilder(argsList).redirectErrorStream(true).start();
            StringBuilder traces = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    traces.append(line).append(System.lineSeparator());
                    line = reader.readLine();
                }
                if (p.isAlive()) {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.errorf((Throwable)e, "Interrupted while waiting for forked process %d to terminate.", (Object)p.pid());
                    }
                }
            }
            if ((exitCode = p.exitValue()) != 0) {
                LOGGER.errorf("Error executing CLI: %s", (Object)traces);
                throw new RuntimeException("CLI execution failed:" + traces);
            }
        }
        finally {
            Files.deleteIfExists(properties);
        }
    }

    private static Path storeSystemProps() throws IOException {
        Path props = Files.createTempFile("wfbootablejar", "sysprops", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(props, new OpenOption[0]);){
            System.getProperties().store(writer, "");
        }
        return props;
    }

    private static void collectCpUrls(ClassLoader cl, StringBuilder buf) {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            ForkedCLIUtil.collectCpUrls(cl.getParent(), buf);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String file;
                try {
                    file = new File(url.toURI()).getAbsolutePath();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (file.startsWith(JAVA_HOME.toString())) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file);
            }
        }
    }

    static {
        String javaHome = System.getProperty("java.home");
        JAVA_HOME = Path.of(javaHome, new String[0]);
        Path cmd = JAVA_HOME.resolve("bin").resolve("java");
        JAVA_CMD = Files.notExists(cmd, new LinkOption[0]) ? "java" : cmd.toAbsolutePath().toString();
    }
}

