/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.AbstractServerManager;
import org.wildfly.plugin.tools.server.CommonOperations;

public class DomainManager
extends AbstractServerManager<DomainClient> {
    private static final Logger LOGGER = Logger.getLogger(DomainManager.class);

    DomainManager(ProcessHandle process, DomainClient client, boolean shutdownOnClose) {
        super(process, client, shutdownOnClose);
    }

    @Override
    public String serverState() {
        try {
            return this.executeOperation(Operations.createReadAttributeOperation((ModelNode)this.determineHostAddress(), (String)"host-state")).asString();
        }
        catch (OperationExecutionException e) {
            LOGGER.debugf("Checking the server state has failed: %s", (Object)Operations.getFailureDescription((ModelNode)e.getExecutionResult()));
        }
        catch (IOException | RuntimeException e) {
            LOGGER.tracef("Interrupted determining the server state", (Object)e);
        }
        return "failed";
    }

    public ModelNode determineHostAddress() throws OperationExecutionException, IOException {
        return CommonOperations.determineHostAddress(this.client());
    }

    @Override
    public boolean isRunning() {
        if (this.process != null) {
            return this.process.isAlive() && CommonOperations.isDomainRunning(this.client(), false);
        }
        return CommonOperations.isDomainRunning(this.client(), false);
    }

    @Override
    public void executeReload() throws IOException, OperationExecutionException {
        this.executeReload(Operations.createOperation((String)"reload-servers"));
    }

    @Override
    public void reloadIfRequired() throws IOException {
        this.reloadIfRequired(10L, TimeUnit.SECONDS);
    }

    @Override
    public void reloadIfRequired(long timeout, TimeUnit unit) throws IOException {
        block6: {
            String launchType = this.launchType();
            if ("DOMAIN".equalsIgnoreCase(launchType)) {
                HashMap<CallSite, ModelNode> steps = new HashMap<CallSite, ModelNode>();
                Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
                int stepCounter = 1;
                ModelNode hostAddress = this.determineHostAddress();
                for (Map.Entry entry : ((DomainClient)this.client).getServerStatuses().entrySet()) {
                    ModelNode address = hostAddress.clone().add("server", ((ServerIdentity)entry.getKey()).getServerName());
                    ModelNode op = Operations.createReadAttributeOperation((ModelNode)address, (String)"server-state");
                    builder.addStep(op);
                    steps.put((CallSite)((Object)("step-" + stepCounter++)), address);
                }
                ModelNode result = this.executeOperation(builder.build());
                builder = Operations.CompositeOperationBuilder.create();
                for (Property serverResult : result.asPropertyList()) {
                    if (!"reload-required".equals(Operations.readResult((ModelNode)serverResult.getValue()).asString())) continue;
                    ModelNode address = (ModelNode)steps.get(serverResult.getName());
                    builder.addStep(Operations.createOperation((String)"reload", (ModelNode)address));
                }
                this.executeOperation(builder.build());
                try {
                    if (!this.waitFor(timeout, unit)) {
                        throw new RuntimeException(String.format("Failed to reload servers within %d %s.", timeout, unit.name().toLowerCase(Locale.ROOT)));
                    }
                    break block6;
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Failed to reload the servers.", interruptedException);
                }
            }
            LOGGER.warnf("Cannot reload and wait for the server to start with a server type of %s.", (Object)launchType);
        }
    }

    @Override
    void internalShutdown(ModelControllerClient client, long timeout) throws IOException {
        ModelNode stopServersOp = Operations.createOperation((String)"stop-servers");
        stopServersOp.get("blocking").set(true);
        stopServersOp.get("timeout").set(timeout);
        DomainManager.executeOperation(client, stopServersOp);
        ModelNode address = CommonOperations.determineHostAddress(client);
        ModelNode shutdownOp = Operations.createOperation((String)"shutdown", (ModelNode)address);
        DomainManager.executeOperation(client, shutdownOp);
    }
}

