/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.zip;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="package", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class ZipPackagingMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(alias="artifact-directory", defaultValue="${project.build.directory}")
    private File artifactDirectory;
    @Parameter(alias="artifact-name", defaultValue="${project.artifactId}-${project.version}.zip")
    private String artifactName;

    public void execute() throws MojoFailureException {
        if (!this.artifactDirectory.exists()) {
            throw new MojoFailureException("artifact-directory " + this.artifactDirectory.getAbsolutePath() + " does not exist");
        }
        if (!this.artifactDirectory.isDirectory()) {
            throw new MojoFailureException("artifact-directory " + this.artifactDirectory.getAbsolutePath() + " is not a directory");
        }
        File f = this.artifactDirectory.toPath().resolve(this.artifactName).toFile();
        if (!f.exists()) {
            throw new MojoFailureException("artifact " + f.getAbsolutePath() + " does not exist");
        }
        if (f.isDirectory()) {
            throw new MojoFailureException("artifact " + f.getAbsolutePath() + " is a directory");
        }
        this.project.getArtifact().setFile(f);
    }
}

