/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="channel")
public class ChannelCommand
extends AbstractCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    public ChannelCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() {
        this.spec.commandLine().usage(this.console.getErrOut());
        return 2;
    }

    @CommandLine.Command(name="list")
    public static class ChannelListCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"})
        Optional<Path> directory;

        public ChannelListCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            List<Channel> channels;
            Path installationDirectory = ChannelListCommand.determineInstallationDirectory(this.directory);
            try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDirectory);){
                channels = metadataAction.getChannels();
            }
            this.console.println("-------");
            for (Channel channel : channels) {
                this.console.println("#" + channel.getName());
                String manifest = channel.getManifestCoordinate().getMaven() == null ? channel.getManifestCoordinate().getUrl().toExternalForm() : ChannelListCommand.toGav(channel.getManifestCoordinate().getMaven());
                this.console.println("  manifest: " + manifest);
                this.console.println("  repositories:");
                for (Repository repository : channel.getRepositories()) {
                    this.console.println("    id: " + repository.getId());
                    this.console.println("    url: " + repository.getUrl());
                }
                this.console.println("-------");
            }
            return 0;
        }

        private static String toGav(MavenCoordinate coord) {
            String ga = coord.getGroupId() + ":" + coord.getArtifactId();
            if (coord.getVersion() != null && !coord.getVersion().isEmpty()) {
                return ga + ":" + coord.getVersion();
            }
            return ga;
        }
    }
}

