/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.InstallationHistoryAction;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.FileConflictPrinter;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.AbstractMavenCommand;
import org.wildfly.prospero.cli.commands.AbstractParentCommand;
import picocli.CommandLine;

@CommandLine.Command(name="revert", sortOptions=false)
public class RevertCommand
extends AbstractParentCommand {
    private static int applyCandidate(CliConsole console, ApplyCandidateAction applyCandidateAction, boolean yes) throws OperationException, ProvisioningException {
        console.changesFound(applyCandidateAction.findUpdates().getArtifactUpdates());
        List<FileConflict> conflicts = applyCandidateAction.getConflicts();
        FileConflictPrinter.print(conflicts, console);
        if (!yes && !console.confirm(CliMessages.MESSAGES.continueWithRevert(), "", CliMessages.MESSAGES.revertCancelled())) {
            return 0;
        }
        applyCandidateAction.applyUpdate(ApplyCandidateAction.Type.REVERT);
        console.println(CliMessages.MESSAGES.revertComplete(applyCandidateAction.getCandidateRevision().getName()));
        return 0;
    }

    private static void validateRevertCandidate(Path installationDirectory, Path updateDirectory, ApplyCandidateAction applyCandidateAction) throws InvalidUpdateCandidateException, MetadataException {
        ApplyCandidateAction.ValidationResult result = applyCandidateAction.verifyCandidate(ApplyCandidateAction.Type.REVERT);
        if (ApplyCandidateAction.ValidationResult.STALE == result) {
            throw CliMessages.MESSAGES.updateCandidateStateNotMatched(installationDirectory, updateDirectory.toAbsolutePath());
        }
        if (ApplyCandidateAction.ValidationResult.WRONG_TYPE == result) {
            throw CliMessages.MESSAGES.updateCandidateWrongType(installationDirectory, ApplyCandidateAction.Type.REVERT);
        }
        if (ApplyCandidateAction.ValidationResult.NOT_CANDIDATE == result) {
            throw CliMessages.MESSAGES.notCandidate(updateDirectory.toAbsolutePath());
        }
    }

    public RevertCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory, "revert", List.of(new PrepareCommand(console, actionFactory), new ApplyCommand(console, actionFactory), new PerformCommand(console, actionFactory)));
    }

    @CommandLine.Command(name="prepare", sortOptions=false)
    public static class PrepareCommand
    extends AbstractMavenCommand {
        @CommandLine.Option(names={"--revision"}, required=true)
        String revision;
        @CommandLine.Option(names={"--candidate-dir"}, required=true)
        Path candidateDirectory;

        public PrepareCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            PrepareCommand.verifyTargetDirectoryIsEmpty(this.candidateDirectory);
            Path installationDirectory = PrepareCommand.determineInstallationDirectory(this.directory);
            MavenOptions mavenOptions = this.parseMavenOptions();
            List<Repository> overrideRepositories = RepositoryDefinition.from(this.temporaryRepositories);
            InstallationHistoryAction historyAction = this.actionFactory.history(installationDirectory, this.console);
            historyAction.prepareRevert(new SavedState(this.revision), mavenOptions, overrideRepositories, this.candidateDirectory.toAbsolutePath());
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }
    }

    @CommandLine.Command(name="apply", sortOptions=false)
    public static class ApplyCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"})
        Optional<Path> directory;
        @CommandLine.Option(names={"--candidate-dir"}, required=true)
        Path candidateDirectory;
        @CommandLine.Option(names={"-y", "--yes"})
        boolean yes;

        public ApplyCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            Path installationDirectory = ApplyCommand.determineInstallationDirectory(this.directory);
            ApplyCandidateAction applyCandidateAction = this.actionFactory.applyUpdate(installationDirectory, this.candidateDirectory.toAbsolutePath());
            RevertCommand.validateRevertCandidate(installationDirectory, this.candidateDirectory, applyCandidateAction);
            RevertCommand.applyCandidate(this.console, applyCandidateAction, this.yes);
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }
    }

    @CommandLine.Command(name="perform", sortOptions=false)
    public static class PerformCommand
    extends AbstractMavenCommand {
        @CommandLine.Option(names={"--revision"}, required=true)
        String revision;
        @CommandLine.Option(names={"-y", "--yes"})
        boolean yes;

        public PerformCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            Path installationDirectory = PerformCommand.determineInstallationDirectory(this.directory);
            MavenOptions mavenOptions = this.parseMavenOptions();
            List<Repository> overrideRepositories = RepositoryDefinition.from(this.temporaryRepositories);
            InstallationHistoryAction historyAction = this.actionFactory.history(installationDirectory, this.console);
            Path tempDirectory = null;
            try {
                tempDirectory = Files.createTempDirectory("revert-candidate", new FileAttribute[0]);
                historyAction.prepareRevert(new SavedState(this.revision), mavenOptions, overrideRepositories, tempDirectory);
                ApplyCandidateAction applyCandidateAction = this.actionFactory.applyUpdate(installationDirectory, tempDirectory);
                RevertCommand.validateRevertCandidate(installationDirectory, tempDirectory, applyCandidateAction);
                RevertCommand.applyCandidate(this.console, applyCandidateAction, this.yes);
                float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
                this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
                Integer n = 0;
                return n;
            }
            catch (IOException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
            }
            finally {
                if (tempDirectory != null) {
                    FileUtils.deleteQuietly(tempDirectory.toFile());
                }
            }
        }
    }
}

