/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.updates;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import org.wildfly.prospero.actions.ApplyCandidateAction;

public class MarkerFile {
    public static final Path UPDATE_MARKER_FILE = Path.of(".installation", ".candidate.txt");
    private static final String STATE_PROPERTY = "state";
    private static final String OPERATION_PROPERTY = "operation";
    private final String state;
    private final ApplyCandidateAction.Type operation;

    public MarkerFile(String state, ApplyCandidateAction.Type operation) {
        this.state = state;
        this.operation = operation;
    }

    public String getState() {
        return this.state;
    }

    public ApplyCandidateAction.Type getOperation() {
        return this.operation;
    }

    public static MarkerFile read(Path serverPath) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(serverPath.resolve(UPDATE_MARKER_FILE).toFile());){
            properties.load(fis);
        }
        ApplyCandidateAction.Type type = ApplyCandidateAction.Type.from(properties.getProperty(OPERATION_PROPERTY));
        return new MarkerFile(properties.getProperty(STATE_PROPERTY), type);
    }

    public void write(Path targetPath) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(STATE_PROPERTY, this.state);
        properties.setProperty(OPERATION_PROPERTY, this.operation.getText());
        try (FileOutputStream fos = new FileOutputStream(targetPath.resolve(UPDATE_MARKER_FILE).toFile());){
            properties.store(fos, null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerFile that = (MarkerFile)o;
        return Objects.equals(this.state, that.state) && Objects.equals((Object)this.operation, (Object)that.operation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.operation});
    }

    public String toString() {
        return "MarkerFile{state='" + this.state + "', operation='" + this.operation + "'}";
    }
}

