/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.io.File;
import java.nio.file.Path;
import java.util.Locale;
import java.util.ResourceBundle;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.DistributionInfo;

public interface CliMessages {
    public static final CliMessages MESSAGES = new CliMessages(){};
    public static final ResourceBundle bundle = ResourceBundle.getBundle("UsageMessages", Locale.getDefault());

    default public String resolvingFeaturePack() {
        return bundle.getString("prospero.install.progress.feature-pack.started");
    }

    default public String installingPackages() {
        return bundle.getString("prospero.install.progress.packages");
    }

    default public String generatingConfiguration() {
        return bundle.getString("prospero.install.progress.config");
    }

    default public String installingJBossModules() {
        return bundle.getString("prospero.install.progress.modules");
    }

    default public String downloadingArtifacts() {
        return bundle.getString("prospero.install.progress.download");
    }

    default public String resolvingVersions() {
        return bundle.getString("prospero.install.progress.versions");
    }

    default public String installingJBossExamples() {
        return bundle.getString("prospero.install.progress.examples");
    }

    default public String featurePacksResolved() {
        return bundle.getString("prospero.install.progress.feature-pack.done");
    }

    default public String packagesInstalled() {
        return bundle.getString("prospero.install.progress.packages.done");
    }

    default public String configurationsGenerated() {
        return bundle.getString("prospero.install.progress.config.done");
    }

    default public String jbossModulesInstalled() {
        return bundle.getString("prospero.install.progress.modules.done");
    }

    default public String jbossExamplesInstalled() {
        return bundle.getString("prospero.install.progress.examples.done");
    }

    default public String artifactsDownloaded() {
        return bundle.getString("prospero.install.progress.download.done");
    }

    default public String versionsResolved() {
        return bundle.getString("prospero.install.progress.versions.done");
    }

    default public String applyingChanges() {
        return bundle.getString("prospero.install.progress.applying_changes");
    }

    default public String noUpdatesFound() {
        return bundle.getString("prospero.updates.no_updates");
    }

    default public String updatesFound() {
        return bundle.getString("prospero.updates.header");
    }

    default public String changesFound() {
        return bundle.getString("prospero.revert.changes.header");
    }

    default public String continueWithUpdate() {
        return bundle.getString("prospero.updates.prompt") + " ";
    }

    default public String continueWithRevert() {
        return bundle.getString("prospero.revert.prompt") + " ";
    }

    default public String continueWithBuildUpdate() {
        return bundle.getString("prospero.updates.build.prompt") + " ";
    }

    default public String updateCancelled() {
        return bundle.getString("prospero.updates.cancelled");
    }

    default public String revertCancelled() {
        return bundle.getString("prospero.revert.cancelled");
    }

    default public String buildUpdateCancelled() {
        return bundle.getString("prospero.updates.build.cancelled");
    }

    default public String applyingUpdates() {
        return bundle.getString("prospero.updates.apply.header");
    }

    default public String buildingUpdates() {
        return bundle.getString("prospero.updates.build.header");
    }

    default public String chooseYN() {
        return bundle.getString("prospero.general.prompt.reminder") + " ";
    }

    default public String updateComplete() {
        return bundle.getString("prospero.updates.complete");
    }

    default public String revertComplete(String revision) {
        return String.format(bundle.getString("prospero.revert.complete"), revision);
    }

    default public String buildUpdateComplete() {
        return bundle.getString("prospero.updates.build.complete");
    }

    default public String yesShortcut() {
        return bundle.getString("prospero.general.prompt.yes");
    }

    default public String noShortcut() {
        return bundle.getString("prospero.general.prompt.no");
    }

    default public String noChangesFound() {
        return bundle.getString("prospero.history.no_updates");
    }

    default public String errorWhenProcessingCommand() {
        return bundle.getString("prospero.general.processing_error") + " ";
    }

    default public String possibleDowngrade() {
        return bundle.getString("prospero.updates.downgrade.warning");
    }

    default public String channelAdded(String urlOrGav) {
        return String.format(bundle.getString("prospero.channels.added"), urlOrGav);
    }

    default public String channelRemoved(String urlOrGav) {
        return String.format(bundle.getString("prospero.channels.removed"), urlOrGav);
    }

    default public String channelNotFound() {
        return bundle.getString("prospero.channels.error.notfound");
    }

    default public String invalidInstallationDir(Path path, String distName) {
        return String.format(bundle.getString("prospero.update.invalid.path"), path, distName);
    }

    default public ArgumentParsingException invalidInstallationDir(Path path) {
        return new ArgumentParsingException(this.invalidInstallationDir(path, DistributionInfo.DIST_NAME), this.requiredMetadata());
    }

    default public String requiredMetadata() {
        return String.format(bundle.getString("prospero.update.invalid.path.details"), ".galleon", ".installation" + File.separator + "installer-channels.yaml");
    }

    default public String forgottenDirArgQuestion() {
        return String.format(bundle.getString("prospero.general.argument.dir.validation.detail"), "--dir");
    }

    default public String addChannels(String channel) {
        return String.format(bundle.getString("prospero.general.argument.channel.validation.nochannel.detail"), channel);
    }

    default public String operationCompleted(float time) {
        return String.format(bundle.getString("prospero.general.operation.completed.time"), Float.valueOf(time));
    }

    default public String customizationRepoExist(String repositoryId) {
        return String.format(bundle.getString("prospero.channels.custom.validation.exists"), repositoryId);
    }

    default public String illegalChannel(String name) {
        return String.format(bundle.getString("prospero.channels.custom.validation.format"), name);
    }

    default public String unableToCreateLocalRepository(Path repositoryPath) {
        return String.format(bundle.getString("prospero.channels.custom.validation.local_repo_create"), repositoryPath);
    }

    default public String wrongChannelCoordinateFormat() {
        return bundle.getString("prospero.channels.promote.validation.format");
    }

    default public String noCustomizationConfigFound(String channelParam, String repoParam) {
        return String.format(bundle.getString("prospero.channels.promote.validation.no_channel_or_repo"), channelParam, repoParam);
    }

    default public String continuePromote() {
        return bundle.getString("prospero.channels.promote.prompt") + " ";
    }

    default public String continuePromoteAccepted() {
        return bundle.getString("prospero.channels.promote.prompt.confirm");
    }

    default public String continuePromoteRejected() {
        return bundle.getString("prospero.channels.promote.prompt.cancelled");
    }

    default public String customizationChannelAlreadyExists() {
        return bundle.getString("prospero.channels.custom.validation.channel.exists");
    }

    default public String registeringCustomChannel(String name) {
        return String.format(bundle.getString("prospero.channels.custom.confirmation.channel"), name);
    }

    default public String manifest() {
        return bundle.getString("prospero.changes.diff.manifest");
    }

    default public String repositories() {
        return bundle.getString("prospero.changes.diff.repositories");
    }

    default public String changeUpdated() {
        return bundle.getString("prospero.changes.diff.updated");
    }

    default public String changeAdded() {
        return bundle.getString("prospero.changes.diff.added");
    }

    default public String changeRemoved() {
        return bundle.getString("prospero.changes.diff.removed");
    }

    default public String diffUpdates() {
        return bundle.getString("prospero.changes.diff.updates");
    }

    default public String diffConfigChanges() {
        return bundle.getString("prospero.changes.diff.conf_changes");
    }

    default public String artifactChangeType() {
        return bundle.getString("prospero.changes.diff.artifact");
    }

    default public String channelChangeType() {
        return bundle.getString("prospero.changes.diff.channel");
    }

    default public String conflictingChangesDetected() {
        return bundle.getString("prospero.changes.conflict.header");
    }

    default public String acceptAgreements() {
        return bundle.getString("prospero.install.agreement.prompt");
    }

    default public String installationCancelled() {
        return bundle.getString("prospero.install.agreement.prompt.cancelled");
    }

    default public String listAgreementsHeader() {
        return bundle.getString("prospero.install.agreement.header");
    }

    default public String noAgreementsNeeded() {
        return bundle.getString("prospero.install.agreement.no_agreement");
    }

    default public String agreementSkipped(String optionName) {
        return String.format(bundle.getString("prospero.install.agreement.skipped"), optionName);
    }

    default public String errorHeader(String msg) {
        return String.format(bundle.getString("prospero.general.error.header"), msg);
    }

    default public String errorSSL() {
        return String.format(bundle.getString("prospero.general.error.ssl"), new Object[0]);
    }

    default public String errorUnknownHost() {
        return String.format(bundle.getString("prospero.general.error.host"), new Object[0]);
    }

    default public String unableToResolveChannelMetadata() {
        return bundle.getString("prospero.general.error.resolve.metadata.header");
    }

    default public String unableToResolveArtifacts() {
        return bundle.getString("prospero.general.error.resolve.artifacts.header");
    }

    default public String streamsNotFound() {
        return bundle.getString("prospero.general.error.resolve.streams.header");
    }

    default public String attemptedRepositories() {
        return bundle.getString("prospero.general.error.resolve.artifacts.repositories");
    }

    default public String missing() {
        return bundle.getString("prospero.general.error.resolve.missing");
    }

    default public String checksumFailed() {
        return bundle.getString("prospero.general.error.resolve.checksum_failed");
    }

    default public String offline() {
        return bundle.getString("prospero.general.error.resolve.offline");
    }

    default public String restoreFileNotExisted(Path path) {
        return String.format(bundle.getString("prospero.clone.error.missing_file"), path);
    }

    default public String installationMetaRestored(Path restorePath, Path installPath) {
        return String.format(bundle.getString("prospero.clone.success"), restorePath, installPath);
    }

    default public ArgumentParsingException unexpectedPackageInSelfUpdate(String path) {
        return new ArgumentParsingException(String.format(bundle.getString("prospero.update.self.validation.feature_pack"), path));
    }

    default public ArgumentParsingException unableToLocateProsperoInstallation() {
        return new ArgumentParsingException(bundle.getString("prospero.update.self.validation.dir.not_found"));
    }

    default public ArgumentParsingException unableToParseSelfUpdateData(Exception e) {
        return new ArgumentParsingException(bundle.getString("prospero.update.self.validation.unknown.installation"), e);
    }

    default public ArgumentParsingException channelsMandatoryWhenCustomFpl(String knownCombintaions) {
        return new ArgumentParsingException(String.format(bundle.getString("prospero.install.validation.unknown_fpl"), knownCombintaions), bundle.getString("prospero.install.validation.unknown_fpl.details"));
    }

    default public ArgumentParsingException invalidInstallationDirMaybeUseDirOption(Path path) {
        return new ArgumentParsingException(this.invalidInstallationDir(path, DistributionInfo.DIST_NAME), this.forgottenDirArgQuestion(), this.requiredMetadata());
    }

    default public IllegalArgumentException exclusiveOptions(String option1, String option2) {
        return new IllegalArgumentException(String.format(bundle.getString("prospero.general.validation.conflicting_options"), option1, option2));
    }

    default public ArgumentParsingException repositoryIsNotDirectory(Path repo) {
        return new ArgumentParsingException(String.format(bundle.getString("prospero.general.validation.local_repo.not_directory"), repo));
    }

    default public ArgumentParsingException invalidRepositoryDefinition(String repoKey) {
        return new ArgumentParsingException(String.format(bundle.getString("prospero.general.validation.repo_format"), repoKey));
    }

    default public IllegalArgumentException updateCandidateStateNotMatched(Path targetDir, Path updateDir) {
        return new IllegalArgumentException(String.format(bundle.getString("prospero.updates.apply.validation.candidate.outdated"), targetDir, updateDir));
    }

    default public IllegalArgumentException updateCandidateWrongType(Path updateDir, ApplyCandidateAction.Type operation) {
        return new IllegalArgumentException(String.format(bundle.getString("prospero.updates.apply.validation.candidate.wrong_type"), updateDir, operation));
    }

    default public IllegalArgumentException notCandidate(Path updateDir) {
        return new IllegalArgumentException(String.format(bundle.getString("prospero.updates.apply.validation.candidate.not_candidate"), updateDir));
    }

    default public IllegalArgumentException nonEmptyTargetFolder() {
        return new IllegalArgumentException(bundle.getString("prospero.updates.build.validation.dir.not_empty"));
    }

    default public ArgumentParsingException unknownInstallationProfile(String profileName, String candidates) {
        return new ArgumentParsingException(String.format(bundle.getString("prospero.install.validation.unknown_profile"), profileName), String.format(bundle.getString("prospero.install.validation.unknown_profile.details"), candidates));
    }
}

