/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.options.LocalRepoOptions;
import picocli.CommandLine;

@CommandLine.Command(name="clone")
public class CloneCommand
extends AbstractCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    public CloneCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    public void addSubCommands(CommandLine rootCmd) {
        CommandLine cloneCmd = (CommandLine)rootCmd.getSubcommands().get("clone");
        cloneCmd.addSubcommand((Object)new CloneExportCommand(this.console, this.actionFactory)).addSubcommand((Object)new CloneRecreateCommand(this.console, this.actionFactory));
    }

    @Override
    public Integer call() {
        this.spec.commandLine().usage(this.console.getErrOut());
        return 2;
    }

    @CommandLine.Command(name="recreate")
    private static class CloneRecreateCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"}, order=1)
        Optional<Path> directory;
        @CommandLine.Option(names={"--path"}, required=true, paramLabel="<path>", order=2)
        Path inPath;
        @CommandLine.Option(names={"--repositories"}, paramLabel="<repo-url>", split=",", order=3)
        List<String> remoteRepositories = new ArrayList<String>();
        @CommandLine.ArgGroup(headingKey="localRepoOptions.heading", order=4)
        LocalRepoOptions localRepoOptions = new LocalRepoOptions();
        @CommandLine.Option(names={"--offline"}, order=5)
        Optional<Boolean> offline = Optional.empty();

        CloneRecreateCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            if (Files.notExists(this.inPath, new LinkOption[0])) {
                this.console.println(CliMessages.MESSAGES.restoreFileNotExisted(this.inPath));
                return 2;
            }
            MavenOptions.Builder mavenOptions = this.localRepoOptions.toOptions();
            this.offline.map(arg_0 -> ((MavenOptions.Builder)mavenOptions).setOffline(arg_0));
            Path installationDirectory = this.directory.orElse(CloneRecreateCommand.currentDir()).toAbsolutePath();
            this.actionFactory.restoreAction(installationDirectory, mavenOptions.build(), this.console).restore(this.inPath, RepositoryDefinition.from(this.remoteRepositories));
            this.console.println(CliMessages.MESSAGES.installationMetaRestored(this.inPath, installationDirectory));
            return 0;
        }
    }

    @CommandLine.Command(name="export")
    private static class CloneExportCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"}, order=1)
        Optional<Path> directory;
        @CommandLine.Option(names={"--path"}, required=true, paramLabel="<path>", order=2)
        Path outPath;

        CloneExportCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            if (Files.exists(this.outPath, new LinkOption[0])) {
                throw ProsperoLogger.ROOT_LOGGER.outFileExists(this.outPath);
            }
            this.actionFactory.exportAction(CloneExportCommand.determineInstallationDirectory(this.directory)).export(this.outPath);
            this.console.println(ProsperoLogger.ROOT_LOGGER.installationExported(this.outPath));
            return 0;
        }
    }
}

