/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.ChannelChange;
import org.wildfly.prospero.api.Diff;
import org.wildfly.prospero.cli.CliMessages;

public class DiffPrinter {
    private final String initialTab;

    public DiffPrinter(String initialTab) {
        this.initialTab = initialTab;
    }

    public void print(Diff diff) {
        this.print(diff, this.initialTab, false);
    }

    private void print(Diff diff, String tab, boolean nested) {
        System.out.print(tab);
        if (diff.getChildren().isEmpty()) {
            String nameText = diff.getName().map(s -> s + ":\t\t").orElse("");
            if (nested) {
                System.out.printf("%s%s ==> %s%n", nameText, diff.getOldValue().orElse("[]"), diff.getNewValue().orElse("[]"));
            } else {
                System.out.printf("[%s] %s%s ==> %s%n", DiffPrinter.getStatus(diff), nameText, diff.getOldValue().orElse("[]"), diff.getNewValue().orElse("[]"));
            }
        } else {
            String nameText = diff.getName().orElse("");
            if (nested) {
                System.out.printf("%s: %n", nameText);
            } else {
                System.out.printf("[%s] %s:%n", DiffPrinter.getStatus(diff), nameText);
            }
            diff.getChildren().forEach(c -> this.print((Diff)c, tab + "  ", true));
        }
    }

    private static String getStatus(Diff diff) {
        String statusText;
        Diff.Status status = diff.getStatus();
        switch (status) {
            case ADDED: {
                statusText = CliMessages.MESSAGES.changeAdded();
                break;
            }
            case REMOVED: {
                statusText = CliMessages.MESSAGES.changeRemoved();
                break;
            }
            case MODIFIED: {
                statusText = CliMessages.MESSAGES.changeUpdated();
                break;
            }
            default: {
                throw new RuntimeException("Unknown status: " + status);
            }
        }
        String diffType = diff instanceof ArtifactChange ? CliMessages.MESSAGES.artifactChangeType() : (diff instanceof ChannelChange ? CliMessages.MESSAGES.channelChangeType() : null);
        return String.format("%s%s", statusText, diffType != null ? " " + diffType : "");
    }
}

