/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.Stream;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.ChannelResolvable;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.galleon.MavenArtifactMapper;

public class ChannelMavenArtifactRepositoryManager
implements MavenRepoManager,
ChannelResolvable {
    private final ChannelSession channelSession;
    private final ChannelManifest manifest;

    public ChannelMavenArtifactRepositoryManager(ChannelSession channelSession) {
        this.channelSession = channelSession;
        this.manifest = null;
    }

    public ChannelMavenArtifactRepositoryManager(ChannelSession channelSession, ChannelManifest manifest) {
        this.channelSession = channelSession;
        this.manifest = manifest;
    }

    @Override
    public void resolve(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        try {
            MavenArtifact result;
            if (this.manifest == null) {
                result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null);
            } else {
                Optional<DefaultArtifact> found = this.manifest.findStreamFor(artifact.getGroupId(), artifact.getArtifactId()).map(this::streamToArtifact);
                if (found.isPresent()) {
                    result = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), found.get().getVersion());
                } else if (this.isUniverseOrProducerArtifact(artifact.getArtifactId())) {
                    result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null);
                } else {
                    throw new MavenUniverseException(ProsperoLogger.ROOT_LOGGER.unableToResolve() + " [" + artifact.getCoordsAsString() + "]");
                }
            }
            MavenArtifactMapper.resolve(artifact, result);
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new MavenUniverseException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void resolveAll(Collection<org.jboss.galleon.universe.maven.MavenArtifact> artifacts) throws MavenUniverseException {
        MavenArtifactMapper mapper = new MavenArtifactMapper(artifacts);
        if (this.manifest == null) {
            List<MavenArtifact> channelArtifacts = this.channelSession.resolveMavenArtifacts(mapper.toChannelArtifacts());
            mapper.applyResolution(channelArtifacts);
        } else {
            List<ArtifactCoordinate> coordinates = this.toResolvableCoordinates(mapper.toChannelArtifacts());
            List<MavenArtifact> channelArtifacts = this.channelSession.resolveDirectMavenArtifacts(coordinates);
            mapper.applyResolution(channelArtifacts);
            for (org.jboss.galleon.universe.maven.MavenArtifact artifact : artifacts) {
                if (artifact.getPath() != null) continue;
                if (this.isUniverseOrProducerArtifact(artifact.getArtifactId())) {
                    MavenArtifact result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null);
                    MavenArtifactMapper.resolve(artifact, result);
                    continue;
                }
                throw new MavenUniverseException(ProsperoLogger.ROOT_LOGGER.unableToResolve() + " [" + artifact.getCoordsAsString() + "]");
            }
        }
    }

    private List<ArtifactCoordinate> toResolvableCoordinates(List<ArtifactCoordinate> artifactCoordinates) throws MavenUniverseException {
        ArrayList<ArtifactCoordinate> coordinates = new ArrayList<ArtifactCoordinate>();
        for (ArtifactCoordinate coord : artifactCoordinates) {
            Optional<DefaultArtifact> found = this.manifest.findStreamFor(coord.getGroupId(), coord.getArtifactId()).map(this::streamToArtifact);
            if (found.isPresent()) {
                coordinates.add(new ArtifactCoordinate(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), found.get().getVersion()));
                continue;
            }
            throw new MavenUniverseException(ProsperoLogger.ROOT_LOGGER.unableToResolve() + " [" + coord.getGroupId() + ":" + coord.getGroupId() + ":" + coord.getExtension() + "]");
        }
        return coordinates;
    }

    private boolean isUniverseOrProducerArtifact(String artifactId) {
        return artifactId.equals("community-universe") || artifactId.equals("wildfly-producers");
    }

    private DefaultArtifact streamToArtifact(Stream s) {
        return new DefaultArtifact(s.getGroupId(), s.getArtifactId(), "jar", s.getVersion());
    }

    @Override
    public boolean isResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isLatestVersionResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        this.resolve(artifact);
    }

    @Override
    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, boolean locallyAvailable) throws MavenUniverseException {
        this.resolve(artifact);
    }

    @Override
    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        return this.getLatestVersion(artifact, null, null, null);
    }

    @Override
    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        return this.getLatestVersion(artifact, lowestQualifier, null, null);
    }

    @Override
    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        try {
            return this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null).getVersion();
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new MavenUniverseException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void install(org.jboss.galleon.universe.maven.MavenArtifact artifact, Path path) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ChannelManifest resolvedChannel() {
        return this.channelSession.getRecordedChannel();
    }
}

