/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.CapabilityProviders;
import org.jboss.galleon.runtime.CapabilityResolver;
import org.jboss.galleon.runtime.CircularRefInfo;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.runtime.SpecFeatures;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.util.CollectionUtils;

public class SpecOnlyConfigArranger {
    private Map<ResolvedSpecId, SpecFeatures> specFeatures;
    private Map<ResolvedFeatureId, ResolvedFeature> features;
    private CapabilityResolver capResolver = new CapabilityResolver();
    private Map<String, CapabilityProviders> capProviders = Collections.emptyMap();
    private List<ResolvedFeature> orderedFeatures = Collections.emptyList();
    private boolean orderReferencedSpec = true;
    private boolean inBatch;

    public List<ResolvedFeature> orderFeatures(ConfigModelStack stack) throws ProvisioningException {
        this.specFeatures = stack.specFeatures;
        this.features = stack.features;
        try {
            this.doOrder(stack.rt);
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToBuildConfigSpec(stack.id.getModel(), stack.id.getName()), e);
        }
        return this.orderedFeatures;
    }

    private void doOrder(ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        for (SpecFeatures features : this.specFeatures.values()) {
            features.spec.resolveRefMappings(rt);
            if (!features.spec.xmlSpec.providesCapabilities()) continue;
            for (CapabilitySpec cap : features.spec.xmlSpec.getProvidedCapabilities()) {
                if (cap.isStatic()) {
                    this.getProviders(cap.toString(), true).add(features);
                    continue;
                }
                for (ResolvedFeature feature : features.getFeatures()) {
                    List<String> resolvedCaps = this.capResolver.resolve(cap, feature);
                    if (resolvedCaps.isEmpty()) continue;
                    for (String resolvedCap : resolvedCaps) {
                        this.getProviders(resolvedCap, true).add(feature);
                    }
                }
            }
        }
        this.orderedFeatures = new ArrayList<ResolvedFeature>(this.features.size());
        for (SpecFeatures features : this.specFeatures.values()) {
            this.orderFeaturesInSpec(features, false);
        }
    }

    private CapabilityProviders getProviders(String cap, boolean add) throws ProvisioningException {
        CapabilityProviders providers = this.capProviders.get(cap);
        if (providers != null) {
            return providers;
        }
        if (!add) {
            throw new ProvisioningException(Errors.noCapabilityProvider(cap));
        }
        providers = new CapabilityProviders();
        this.capProviders = CollectionUtils.put(this.capProviders, cap, providers);
        return providers;
    }

    private List<CircularRefInfo> orderFeaturesInSpec(SpecFeatures specFeatures, boolean force) throws ProvisioningException {
        if (!force) {
            if (!specFeatures.isFree()) {
                return null;
            }
            specFeatures.schedule();
        }
        List<CircularRefInfo> allCircularRefs = null;
        int i = 0;
        List<ResolvedFeature> features = specFeatures.getFeatures();
        while (i < features.size() && allCircularRefs == null) {
            allCircularRefs = this.orderFeature(features.get(i++));
        }
        if (!force) {
            specFeatures.free();
        }
        return allCircularRefs;
    }

    private List<CircularRefInfo> orderFeature(ResolvedFeature feature) throws ProvisioningException {
        List<ResolvedFeatureId> refIds;
        if (feature.isOrdered()) {
            return null;
        }
        if (!feature.isFree()) {
            return Collections.singletonList(new CircularRefInfo(feature));
        }
        feature.schedule();
        List<CircularRefInfo> circularRefs = null;
        if (feature.spec.xmlSpec.requiresCapabilities()) {
            circularRefs = this.orderCapabilityProviders(feature, circularRefs);
        }
        if (!feature.deps.isEmpty()) {
            circularRefs = this.orderReferencedFeatures(feature, feature.deps.keySet(), false, circularRefs);
        }
        if (!(refIds = feature.resolveRefs()).isEmpty()) {
            circularRefs = this.orderReferencedFeatures(feature, refIds, true, circularRefs);
        }
        List<Object> initiatedCircularRefs = Collections.emptyList();
        if (circularRefs != null) {
            if (circularRefs.size() == 1) {
                CircularRefInfo next = circularRefs.get(0);
                if (next.loopedOn.id.equals(feature.id)) {
                    circularRefs = Collections.emptyList();
                    initiatedCircularRefs = Collections.singletonList(next);
                } else {
                    next.setNext(feature);
                    feature.free();
                }
            } else {
                Iterator<CircularRefInfo> i = circularRefs.iterator();
                while (i.hasNext()) {
                    CircularRefInfo next = i.next();
                    if (next.loopedOn.id.equals(feature.id)) {
                        i.remove();
                        initiatedCircularRefs = CollectionUtils.add(initiatedCircularRefs, next);
                        continue;
                    }
                    next.setNext(feature);
                    feature.free();
                }
            }
            if (!circularRefs.isEmpty()) {
                return circularRefs;
            }
        }
        if (!initiatedCircularRefs.isEmpty()) {
            boolean prevOrderRefSpec = this.orderReferencedSpec;
            this.orderReferencedSpec = false;
            initiatedCircularRefs.sort(CircularRefInfo.getFirstInConfigComparator());
            if (((CircularRefInfo)initiatedCircularRefs.get((int)0)).firstInConfig.includeNo < feature.includeNo) {
                feature.free();
                for (CircularRefInfo circularRefInfo : initiatedCircularRefs) {
                    if (this.orderFeature(circularRefInfo.firstInConfig) == null) continue;
                    throw new IllegalStateException();
                }
            } else {
                boolean endBatch;
                if (this.inBatch) {
                    endBatch = false;
                } else {
                    this.inBatch = true;
                    feature.startBatch();
                    endBatch = true;
                }
                feature.ordered();
                this.orderedFeatures.add(feature);
                initiatedCircularRefs.sort(CircularRefInfo.getNextOnPathComparator());
                for (CircularRefInfo circularRefInfo : initiatedCircularRefs) {
                    if (this.orderFeature(circularRefInfo.nextOnPath) == null) continue;
                    throw new IllegalStateException();
                }
                if (endBatch) {
                    this.inBatch = false;
                    this.orderedFeatures.get(this.orderedFeatures.size() - 1).endBatch();
                }
            }
            this.orderReferencedSpec = prevOrderRefSpec;
        } else {
            feature.ordered();
            this.orderedFeatures.add(feature);
        }
        return null;
    }

    private List<CircularRefInfo> orderCapabilityProviders(ResolvedFeature feature, List<CircularRefInfo> circularRefs) throws ProvisioningException {
        for (CapabilitySpec capSpec : feature.spec.xmlSpec.getRequiredCapabilities()) {
            List<String> resolvedCaps = this.capResolver.resolve(capSpec, feature);
            if (resolvedCaps.isEmpty()) continue;
            for (String resolvedCap : resolvedCaps) {
                CapabilityProviders providers;
                try {
                    providers = this.getProviders(resolvedCap, false);
                }
                catch (ProvisioningException e) {
                    throw new ProvisioningException(Errors.noCapabilityProvider(feature, capSpec, resolvedCap));
                }
                List<CircularRefInfo> circles = this.orderProviders(providers);
                if (circularRefs == null) {
                    circularRefs = circles;
                    continue;
                }
                if (circularRefs.size() == 1) {
                    CircularRefInfo first = circularRefs.get(0);
                    circularRefs = new ArrayList<CircularRefInfo>(1 + circles.size());
                    circularRefs.add(first);
                }
                circularRefs.addAll(circles);
            }
        }
        return circularRefs;
    }

    private List<CircularRefInfo> orderProviders(CapabilityProviders providers) throws ProvisioningException {
        if (!providers.isProvided()) {
            List<CircularRefInfo> loop;
            List<CircularRefInfo> firstLoop = null;
            if (!providers.specs.isEmpty()) {
                Iterator<Object> iterator = providers.specs.iterator();
                while (iterator.hasNext()) {
                    SpecFeatures specFeatures;
                    loop = this.orderFeaturesInSpec(specFeatures, !(specFeatures = iterator.next()).isFree());
                    if (providers.isProvided()) {
                        return null;
                    }
                    if (firstLoop != null) continue;
                    firstLoop = loop;
                }
            }
            if (!providers.features.isEmpty()) {
                for (ResolvedFeature provider : providers.features) {
                    loop = this.orderFeature(provider);
                    if (providers.isProvided()) {
                        return null;
                    }
                    if (firstLoop != null) continue;
                    firstLoop = loop;
                }
            }
            return firstLoop;
        }
        return null;
    }

    private List<CircularRefInfo> orderReferencedFeatures(ResolvedFeature feature, Collection<ResolvedFeatureId> refIds, boolean specRefs, List<CircularRefInfo> circularRefs) throws ProvisioningException {
        for (ResolvedFeatureId refId : refIds) {
            List<CircularRefInfo> loopedOnFeature = this.orderReferencedFeature(feature, refId, specRefs);
            if (loopedOnFeature == null) continue;
            if (circularRefs == null) {
                circularRefs = loopedOnFeature;
                continue;
            }
            if (circularRefs.size() == 1) {
                CircularRefInfo first = circularRefs.get(0);
                circularRefs = new ArrayList<CircularRefInfo>(1 + loopedOnFeature.size());
                circularRefs.add(first);
            }
            circularRefs.addAll(loopedOnFeature);
        }
        return circularRefs;
    }

    private List<CircularRefInfo> orderReferencedFeature(ResolvedFeature feature, ResolvedFeatureId refId, boolean specRef) throws ProvisioningException {
        ResolvedFeature dep;
        if (this.orderReferencedSpec && specRef && !feature.spec.id.equals(refId.specId)) {
            SpecFeatures targetSpecFeatures = this.specFeatures.get(refId.specId);
            if (targetSpecFeatures == null) {
                throw new ProvisioningDescriptionException(Errors.unresolvedFeatureDep(feature, refId));
            }
            List<CircularRefInfo> specLoops = this.orderFeaturesInSpec(targetSpecFeatures, false);
            if (specLoops != null) {
                List<CircularRefInfo> featureLoops = null;
                for (int i = 0; i < specLoops.size(); ++i) {
                    CircularRefInfo specLoop = specLoops.get(i);
                    if (!specLoop.nextOnPath.id.equals(refId)) continue;
                    if (featureLoops == null) {
                        featureLoops = Collections.singletonList(specLoop);
                        continue;
                    }
                    if (featureLoops.size() == 1) {
                        CircularRefInfo first = featureLoops.get(0);
                        featureLoops = new ArrayList<CircularRefInfo>(2);
                        featureLoops.add(first);
                    }
                    featureLoops.add(specLoop);
                }
                if (featureLoops != null) {
                    return featureLoops;
                }
            }
        }
        if ((dep = this.features.get(refId)) == null) {
            throw new ProvisioningDescriptionException(Errors.unresolvedFeatureDep(feature, refId));
        }
        return this.orderFeature(dep);
    }
}

