/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import org.jboss.galleon.spec.ConfigLayerDependency;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ConfigLayerXml;
import org.jboss.galleon.xml.FeatureGroupXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;

public class ConfigLayerXmlWriter
extends BaseXmlWriter<ConfigLayerSpec> {
    private static final ConfigLayerXmlWriter INSTANCE = new ConfigLayerXmlWriter();

    public static ConfigLayerXmlWriter getInstance() {
        return INSTANCE;
    }

    private ConfigLayerXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ConfigLayerSpec layer) {
        return this.toElement(layer, "urn:jboss:galleon:layer-spec:1.0");
    }

    protected ElementNode toElement(ConfigLayerSpec layer, String ns) {
        ElementNode configE = ConfigLayerXmlWriter.addElement(null, ConfigLayerXml.Element.LAYER_SPEC.getLocalName(), ns);
        ConfigLayerXmlWriter.addAttribute(configE, ConfigLayerXml.Attribute.NAME, layer.getName());
        if (layer.hasLayerDeps()) {
            ElementNode layers = ConfigLayerXmlWriter.addElement(configE, ConfigLayerXml.Element.DEPENDENCIES.getLocalName(), ns);
            for (ConfigLayerDependency layerDep : layer.getLayerDeps()) {
                ElementNode layerE = ConfigLayerXmlWriter.addElement(layers, ConfigLayerXml.Element.LAYER.getLocalName(), ns);
                ConfigLayerXmlWriter.addAttribute(layerE, ConfigLayerXml.Attribute.NAME, layerDep.getName());
                if (!layerDep.isOptional()) continue;
                ConfigLayerXmlWriter.addAttribute(layerE, ConfigLayerXml.Attribute.OPTIONAL, "true");
            }
        }
        FeatureGroupXmlWriter.addFeatureGroupDepBody(layer, configE, ns);
        return configE;
    }
}

