/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import org.jboss.logging.Logger;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.ExecutionExceptionHandler;
import org.wildfly.prospero.cli.commands.ChannelCommand;
import org.wildfly.prospero.cli.commands.CloneCommand;
import org.wildfly.prospero.cli.commands.CompletionCommand;
import org.wildfly.prospero.cli.commands.HistoryCommand;
import org.wildfly.prospero.cli.commands.InstallCommand;
import org.wildfly.prospero.cli.commands.MainCommand;
import org.wildfly.prospero.cli.commands.PrintLicensesCommand;
import org.wildfly.prospero.cli.commands.RevertCommand;
import org.wildfly.prospero.cli.commands.UpdateCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelAddCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelInitializeCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelPromoteCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelRemoveCommand;
import picocli.CommandLine;

public class CliMain {
    private static final Logger logger;

    private static void enableJBossLogManager() {
        if (System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        }
    }

    public static void main(String[] args) {
        try {
            CliConsole console = new CliConsole();
            CommandLine commandLine = CliMain.createCommandLine(console);
            int exitCode = commandLine.execute(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println(CliMessages.MESSAGES.errorWhenProcessingCommand() + e.getMessage());
            logger.error((Object)CliMessages.MESSAGES.errorWhenProcessingCommand(), e);
            System.exit(1);
        }
    }

    public static CommandLine createCommandLine(CliConsole console) {
        return CliMain.createCommandLine(console, new ActionFactory());
    }

    public static CommandLine createCommandLine(CliConsole console, ActionFactory actionFactory) {
        CommandLine commandLine = new CommandLine(new MainCommand(console));
        commandLine.addSubcommand(new InstallCommand(console, actionFactory));
        UpdateCommand updateCommand = new UpdateCommand(console, actionFactory);
        commandLine.addSubcommand(updateCommand);
        updateCommand.addSubCommands(commandLine);
        commandLine.addSubcommand(new PrintLicensesCommand(console, actionFactory));
        commandLine.addSubcommand(new HistoryCommand(console, actionFactory));
        RevertCommand revertCommand = new RevertCommand(console, actionFactory);
        commandLine.addSubcommand(revertCommand);
        revertCommand.addSubCommands(commandLine);
        commandLine.addSubcommand(new ChannelCommand(console, actionFactory));
        commandLine.addSubcommand(new CompletionCommand());
        CommandLine channelCmd = commandLine.getSubcommands().get("channel");
        channelCmd.addSubcommand(new ChannelAddCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelRemoveCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelCommand.ChannelListCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelInitializeCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelPromoteCommand(console, actionFactory));
        CloneCommand cloneCommand = new CloneCommand(console, actionFactory);
        commandLine.addSubcommand(cloneCommand);
        cloneCommand.addSubCommands(commandLine);
        commandLine.setUsageHelpAutoWidth(true);
        commandLine.setExecutionExceptionHandler(new ExecutionExceptionHandler(console));
        return commandLine;
    }

    static {
        CliMain.enableJBossLogManager();
        logger = Logger.getLogger(CliMain.class);
    }
}

