/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.galleon.config.FeaturePackConfig;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.options.LocalRepoOptions;
import org.wildfly.prospero.cli.printers.ChannelPrinter;
import picocli.CommandLine;

@CommandLine.Command(name="clone")
public class CloneCommand
extends AbstractCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    public CloneCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    public void addSubCommands(CommandLine rootCmd) {
        CommandLine cloneCmd = rootCmd.getSubcommands().get("clone");
        cloneCmd.addSubcommand(new CloneExportCommand(this.console, this.actionFactory)).addSubcommand(new CloneRecreateCommand(this.console, this.actionFactory));
    }

    @Override
    public Integer call() {
        this.spec.commandLine().usage(this.console.getErrOut());
        return 2;
    }

    @CommandLine.Command(name="recreate")
    private static class CloneRecreateCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"}, order=1)
        Optional<Path> directory;
        @CommandLine.Option(names={"--path"}, required=true, paramLabel="<path>", order=2)
        Path inPath;
        @CommandLine.Option(names={"--repositories"}, paramLabel="<repo-url>", split=",", order=3)
        List<String> remoteRepositories = new ArrayList<String>();
        @CommandLine.ArgGroup(headingKey="localRepoOptions.heading", order=4)
        LocalRepoOptions localRepoOptions = new LocalRepoOptions();
        @CommandLine.Option(names={"--offline"}, order=5)
        Optional<Boolean> offline = Optional.empty();

        CloneRecreateCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            if (Files.notExists(this.inPath.toAbsolutePath(), new LinkOption[0])) {
                throw new ArgumentParsingException(CliMessages.MESSAGES.restoreFileNotExisted(this.inPath.toAbsolutePath()));
            }
            MavenOptions.Builder mavenOptions = this.localRepoOptions.toOptions();
            this.offline.map(mavenOptions::setOffline);
            Path installationDirectory = this.directory.orElse(CloneRecreateCommand.currentDir()).toAbsolutePath();
            this.console.println(CliMessages.MESSAGES.recreatingServer(installationDirectory, this.inPath));
            try (InstallationMetadata metadataBundle = InstallationMetadata.fromMetadataBundle(this.inPath.toAbsolutePath());){
                this.console.println(CliMessages.MESSAGES.provisioningConfigHeader());
                for (FeaturePackConfig featurePackDep : metadataBundle.getGalleonProvisioningConfig().getFeaturePackDeps()) {
                    this.console.println(" * " + featurePackDep.getLocation().toString());
                }
                this.console.println(CliMessages.MESSAGES.subscribedChannelsHeader());
                ChannelPrinter channelPrinter = new ChannelPrinter(this.console);
                for (Channel channel : metadataBundle.getProsperoConfig().getChannels()) {
                    channelPrinter.print(channel);
                }
            }
            this.console.println("");
            this.actionFactory.restoreAction(installationDirectory, mavenOptions.build(), this.console).restore(this.inPath, RepositoryDefinition.from(this.remoteRepositories));
            this.console.println("");
            this.console.println(CliMessages.MESSAGES.installationMetaRestored());
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }
    }

    @CommandLine.Command(name="export")
    private static class CloneExportCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"}, order=1)
        Optional<Path> directory;
        @CommandLine.Option(names={"--path"}, required=true, paramLabel="<path>", order=2)
        Path outPath;

        CloneExportCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            if (Files.exists(this.outPath, new LinkOption[0])) {
                throw ProsperoLogger.ROOT_LOGGER.outFileExists(this.outPath);
            }
            CloneExportCommand.verifyTargetDirectoryIsEmpty(this.outPath);
            Path installationDir = CloneExportCommand.determineInstallationDirectory(this.directory);
            this.console.println(CliMessages.MESSAGES.exportInstallationDetailsHeader(installationDir, this.outPath));
            this.actionFactory.exportAction(installationDir).export(this.outPath);
            this.console.println(CliMessages.MESSAGES.exportInstallationDetailsDone());
            return 0;
        }
    }
}

