/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.exceptions.MetadataException;

public class ChannelManifestSubstitutor {
    private static final Logger logger = Logger.getLogger(ChannelManifestSubstitutor.class);
    private final Map<String, String> properties;

    public ChannelManifestSubstitutor(Map<String, String> properties) {
        this.properties = properties;
    }

    public Channel substitute(Channel channel) throws MetadataException {
        URL substitutedURL;
        String url;
        ChannelManifestCoordinate channelManifestCoordinate = channel.getManifestCoordinate();
        if (channelManifestCoordinate.getUrl() == null) {
            return channel;
        }
        String substituted = url = channelManifestCoordinate.getUrl().toString();
        for (String key : this.properties.keySet()) {
            substituted = substituted.replaceAll("\\$\\{" + key + "\\}", this.properties.get(key));
        }
        if (url.equals(substituted)) {
            return channel;
        }
        try {
            substitutedURL = new URL(substituted);
        }
        catch (MalformedURLException e) {
            throw ProsperoLogger.ROOT_LOGGER.invalidPropertySubstitutionValue(substituted, url);
        }
        logger.debug("Channel's manifest URL " + url + " is substituted by " + substituted);
        ChannelManifestCoordinate substitutedChannelManifestCoordinate = new ChannelManifestCoordinate(substitutedURL);
        if (channel.getSchemaVersion().isEmpty()) {
            return new Channel(channel.getName(), channel.getDescription(), channel.getVendor(), channel.getRepositories(), substitutedChannelManifestCoordinate, channel.getBlocklistCoordinate(), channel.getNoStreamStrategy());
        }
        return new Channel(channel.getSchemaVersion(), channel.getName(), channel.getDescription(), channel.getVendor(), channel.getRepositories(), substitutedChannelManifestCoordinate, channel.getBlocklistCoordinate(), channel.getNoStreamStrategy());
    }
}

