/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.jboss.galleon.util.HashUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.prospero.metadata.ManifestVersionRecord;

public class ManifestVersionResolver {
    private final VersionResolverFactory resolverFactory;

    public ManifestVersionResolver(Path localMavenCache, RepositorySystem system) {
        Objects.requireNonNull(localMavenCache);
        Objects.requireNonNull(system);
        DefaultRepositorySystemSession session = ManifestVersionResolver.newRepositorySystemSession(system, localMavenCache);
        this.resolverFactory = new VersionResolverFactory(system, session);
    }

    ManifestVersionResolver(VersionResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
    }

    public ManifestVersionRecord getCurrentVersions(List<Channel> channels) throws IOException {
        Objects.requireNonNull(channels);
        ManifestVersionRecord manifestVersionRecord = new ManifestVersionRecord();
        for (Channel channel : channels) {
            ChannelManifestCoordinate manifestCoordinate = channel.getManifestCoordinate();
            if (manifestCoordinate == null) {
                List<String> repos = channel.getRepositories().stream().map(Repository::getId).collect(Collectors.toList());
                manifestVersionRecord.addManifest(new ManifestVersionRecord.NoManifest(repos, channel.getNoStreamStrategy().toString()));
                continue;
            }
            if (manifestCoordinate.getUrl() != null) {
                String content = this.read(manifestCoordinate.getUrl());
                String hashCode = HashUtils.hash(content);
                manifestVersionRecord.addManifest(new ManifestVersionRecord.UrlManifest(manifestCoordinate.getUrl().toExternalForm(), hashCode));
                continue;
            }
            if (manifestCoordinate.getVersion() != null) {
                manifestVersionRecord.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getVersion()));
                continue;
            }
            MavenVersionsResolver mavenVersionsResolver = this.resolverFactory.create((Collection<Repository>)channel.getRepositories());
            Optional<String> latestVersion = VersionMatcher.getLatestVersion(mavenVersionsResolver.getAllVersions(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getExtension(), manifestCoordinate.getClassifier()));
            manifestVersionRecord.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), latestVersion.get()));
        }
        return manifestVersionRecord;
    }

    private String read(URL url) throws IOException {
        InputStream inputStream = url.openStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        inputStream.transferTo(outputStream);
        return ((Object)outputStream).toString();
    }

    private static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, Path localMavenCache) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localMavenCache.toFile());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, localRepo));
        session.setOffline(true);
        return session;
    }
}

