/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.ProvisioningProgressEvent;
import org.wildfly.prospero.cli.CliMessages;

public class CliConsole
implements Console {
    private static final int MAX_LENGTH = 120;
    private static HashMap<String, ProgressLogger> loggers = new HashMap();
    private Cli cli = new Cli(this.getStdOut());

    public CliConsole() {
        loggers.put("LAYOUT_BUILD", new ProgressLogger(CliMessages.MESSAGES.resolvingFeaturePack(), CliMessages.MESSAGES.featurePacksResolved()));
        loggers.put("PACKAGES", new ProgressLogger(CliMessages.MESSAGES.installingPackages(), CliMessages.MESSAGES.packagesInstalled()));
        loggers.put("CONFIGS", new ProgressLogger(CliMessages.MESSAGES.generatingConfiguration(), CliMessages.MESSAGES.configurationsGenerated()));
        loggers.put("JBMODULES", new ProgressLogger(CliMessages.MESSAGES.installingJBossModules(), CliMessages.MESSAGES.jbossModulesInstalled()));
        loggers.put("JBEXTRACONFIGS", new ProgressLogger(CliMessages.MESSAGES.installingJBossExamples(), CliMessages.MESSAGES.jbossExamplesInstalled()));
        loggers.put("JB_ARTIFACTS_RESOLVE", new ProgressLogger(CliMessages.MESSAGES.downloadingArtifacts(), CliMessages.MESSAGES.artifactsDownloaded()));
        loggers.put("RESOLVING_VERSIONS", new ProgressLogger(CliMessages.MESSAGES.resolvingVersions(), CliMessages.MESSAGES.versionsResolved()));
    }

    public void progressUpdate(ProvisioningProgressEvent update) {
        ProgressLogger logger = loggers.get(update.getStage());
        if (update.getEventType() == ProvisioningProgressEvent.EventType.STARTING) {
            this.cli.print(logger.starting());
        }
        if (update.getEventType() == ProvisioningProgressEvent.EventType.UPDATE) {
            Object text;
            Object item = update.isSlowPhase() ? " " + CliMessages.MESSAGES.installProgressWait() + "..." : update.getCurrentItem();
            Object details = item == null ? "" : item;
            String progressMsg = update.getTotal() > 0L ? String.format(" %d/%d(%.0f%%) ", update.getCompleted(), update.getTotal(), update.getProgress()) : "";
            if (logger.progress.length() + progressMsg.length() > 120) {
                text = (logger.progress() + progressMsg).substring(0, 120);
            } else if (logger.progress.length() + progressMsg.length() + ((String)details).length() > 120) {
                int used = logger.progress.length() + progressMsg.length();
                int left = 120 - used;
                text = logger.progress() + progressMsg + "..." + ((String)details).substring(((String)details).length() - left);
            } else {
                text = logger.progress() + progressMsg + (String)details;
            }
            this.cli.print((String)text);
        }
        if (update.getEventType() == ProvisioningProgressEvent.EventType.COMPLETED) {
            this.cli.println(logger.completed());
        }
    }

    public void updatesFound(List<ArtifactChange> artifactUpdates) {
        if (artifactUpdates.isEmpty()) {
            this.getStdOut().println(CliMessages.MESSAGES.noUpdatesFound());
        } else {
            this.getStdOut().println(CliMessages.MESSAGES.updatesFound());
            for (ArtifactChange artifactUpdate : artifactUpdates) {
                Optional newVersion = artifactUpdate.getNewVersion();
                Optional oldVersion = artifactUpdate.getOldVersion();
                String artifactName = artifactUpdate.getArtifactName();
                this.getStdOut().printf("  %s%-50s    %-20s ==>  %-20s%n", artifactUpdate.isDowngrade() ? "[*]" : "", artifactName, oldVersion.orElse("[]"), newVersion.orElse("[]"));
            }
            if (artifactUpdates.stream().anyMatch(ArtifactChange::isDowngrade)) {
                this.getStdOut().printf(CliMessages.MESSAGES.possibleDowngrade(), new Object[0]);
            }
        }
    }

    public void changesFound(List<ArtifactChange> artifactUpdates) {
        if (artifactUpdates.isEmpty()) {
            this.getStdOut().println(CliMessages.MESSAGES.noChangesFound());
        } else {
            this.getStdOut().println(CliMessages.MESSAGES.changesFound());
            for (ArtifactChange artifactUpdate : artifactUpdates) {
                Optional newVersion = artifactUpdate.getNewVersion();
                Optional oldVersion = artifactUpdate.getOldVersion();
                String artifactName = artifactUpdate.getArtifactName();
                this.getStdOut().printf("  %-50s    %-20s ==>  %-20s%n", artifactName, oldVersion.orElse("[]"), newVersion.orElse("[]"));
            }
        }
    }

    public boolean confirmUpdates() {
        return this.confirm(CliMessages.MESSAGES.continueWithUpdate(), CliMessages.MESSAGES.buildingUpdates(), CliMessages.MESSAGES.updateCancelled());
    }

    public boolean confirmBuildUpdates() {
        return this.confirm(CliMessages.MESSAGES.continueWithBuildUpdate(), CliMessages.MESSAGES.buildingUpdates(), CliMessages.MESSAGES.buildUpdateCancelled());
    }

    public boolean confirm(String prompt, String accepted, String cancelled) {
        this.getStdOut().print(prompt);
        Scanner sc = new Scanner(this.getInput());
        while (true) {
            String resp;
            if ((resp = sc.nextLine()).equalsIgnoreCase(CliMessages.MESSAGES.noShortcut()) || resp.isBlank()) {
                this.println(cancelled);
                return false;
            }
            if (resp.equalsIgnoreCase(CliMessages.MESSAGES.yesShortcut())) {
                this.println(accepted);
                return true;
            }
            this.getStdOut().print(CliMessages.MESSAGES.chooseYN());
        }
    }

    public void updatesComplete() {
        this.println(CliMessages.MESSAGES.updateComplete());
    }

    public void buildUpdatesComplete() {
        this.println(CliMessages.MESSAGES.buildUpdateComplete());
    }

    public PrintStream getStdOut() {
        return System.out;
    }

    public PrintStream getErrOut() {
        return System.err;
    }

    public InputStream getInput() {
        return System.in;
    }

    public void error(String message, String ... args) {
        this.getErrOut().println(String.format(message, args));
    }

    public void println(String text) {
        this.getStdOut().println(text);
    }

    private class Cli {
        int lastLength;
        PrintStream out;

        Cli(PrintStream out) {
            this.out = out;
        }

        synchronized void print(String msg) {
            String eraser = StringUtils.repeat((char)' ', (int)this.lastLength);
            this.out.print("\r" + eraser + "\r");
            this.lastLength = msg.length();
            this.out.print(msg);
        }

        synchronized void println(String msg) {
            String eraser = StringUtils.repeat((char)' ', (int)this.lastLength);
            this.out.print("\r" + eraser + "\r");
            this.lastLength = msg.length();
            this.out.println(msg);
        }
    }

    private class ProgressLogger {
        private String starting;
        private String completed;
        private String progress;

        ProgressLogger(String starting, String completed, String progress) {
            this.starting = starting;
            this.completed = completed;
            this.progress = progress;
        }

        ProgressLogger(String starting, String completed) {
            this.starting = starting;
            this.completed = completed;
            this.progress = starting;
        }

        String starting() {
            return this.starting;
        }

        String completed() {
            return this.completed;
        }

        String progress() {
            return this.progress;
        }
    }
}

