/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import org.jboss.logging.Logger;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.ExecutionExceptionHandler;
import org.wildfly.prospero.cli.commands.ChannelCommand;
import org.wildfly.prospero.cli.commands.CloneCommand;
import org.wildfly.prospero.cli.commands.CompletionCommand;
import org.wildfly.prospero.cli.commands.HistoryCommand;
import org.wildfly.prospero.cli.commands.InstallCommand;
import org.wildfly.prospero.cli.commands.MainCommand;
import org.wildfly.prospero.cli.commands.PrintLicensesCommand;
import org.wildfly.prospero.cli.commands.RevertCommand;
import org.wildfly.prospero.cli.commands.UpdateCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelAddCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelInitializeCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelPromoteCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelRemoveCommand;
import picocli.CommandLine;

public class CliMain {
    private static final Logger logger;

    private static void enableJBossLogManager() {
        if (System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        }
    }

    public static void main(String[] args) {
        try {
            CliConsole console = new CliConsole();
            CommandLine commandLine = CliMain.createCommandLine(console);
            int exitCode = commandLine.execute(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println(CliMessages.MESSAGES.errorWhenProcessingCommand() + e.getMessage());
            logger.error((Object)CliMessages.MESSAGES.errorWhenProcessingCommand(), (Throwable)e);
            System.exit(1);
        }
    }

    public static CommandLine createCommandLine(CliConsole console) {
        return CliMain.createCommandLine(console, new ActionFactory());
    }

    public static CommandLine createCommandLine(CliConsole console, ActionFactory actionFactory) {
        CommandLine commandLine = new CommandLine((Object)new MainCommand(console));
        commandLine.addSubcommand((Object)new InstallCommand(console, actionFactory));
        UpdateCommand updateCommand = new UpdateCommand(console, actionFactory);
        commandLine.addSubcommand((Object)updateCommand);
        updateCommand.addSubCommands(commandLine);
        commandLine.addSubcommand((Object)new PrintLicensesCommand(console, actionFactory));
        commandLine.addSubcommand((Object)new HistoryCommand(console, actionFactory));
        RevertCommand revertCommand = new RevertCommand(console, actionFactory);
        commandLine.addSubcommand((Object)revertCommand);
        revertCommand.addSubCommands(commandLine);
        commandLine.addSubcommand((Object)new ChannelCommand(console, actionFactory));
        commandLine.addSubcommand((Object)new CompletionCommand());
        CommandLine channelCmd = (CommandLine)commandLine.getSubcommands().get("channel");
        channelCmd.addSubcommand((Object)new ChannelAddCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelRemoveCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelCommand.ChannelListCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelInitializeCommand(console, actionFactory));
        channelCmd.addSubcommand((Object)new ChannelPromoteCommand(console, actionFactory));
        CloneCommand cloneCommand = new CloneCommand(console, actionFactory);
        commandLine.addSubcommand((Object)cloneCommand);
        cloneCommand.addSubCommands(commandLine);
        commandLine.setUsageHelpAutoWidth(true);
        commandLine.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExecutionExceptionHandler(console));
        return commandLine;
    }

    static {
        CliMain.enableJBossLogManager();
        logger = Logger.getLogger(CliMain.class);
    }
}

