/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.galleon.config.ProvisioningConfig;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.prospero.actions.ProvisioningAction;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.KnownFeaturePacks;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.ProvisioningDefinition;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.LicensePrinter;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractInstallCommand;
import org.wildfly.prospero.cli.commands.options.FeaturePackCandidates;
import org.wildfly.prospero.cli.printers.ChannelPrinter;
import picocli.CommandLine;

@CommandLine.Command(name="install", sortOptions=false)
public class InstallCommand
extends AbstractInstallCommand {
    @CommandLine.Option(names={"--dir"}, required=true, order=2)
    Path directory;
    @CommandLine.Option(names={"--accept-license-agreements"}, order=8)
    boolean acceptAgreements;
    @CommandLine.Option(names={"--shade-repositories"}, split=",", hidden=true)
    List<String> shadowRepositories = new ArrayList<String>();

    public InstallCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        long startTime = System.currentTimeMillis();
        assert (this.featurePackOrDefinition.definition.isPresent() || this.featurePackOrDefinition.fpl.isPresent() || this.featurePackOrDefinition.profile.isPresent());
        if (this.featurePackOrDefinition.profile.isEmpty() && this.channelCoordinates.isEmpty() && this.manifestCoordinate.isEmpty()) {
            throw CliMessages.MESSAGES.channelsMandatoryWhenCustomFpl(String.join((CharSequence)",", KnownFeaturePacks.getNames()));
        }
        if (this.featurePackOrDefinition.profile.isPresent() && !this.isStandardFpl(this.featurePackOrDefinition.profile.get())) {
            throw CliMessages.MESSAGES.unknownInstallationProfile(this.featurePackOrDefinition.profile.get(), String.join((CharSequence)",", KnownFeaturePacks.getNames()));
        }
        if (!this.channelCoordinates.isEmpty() && this.manifestCoordinate.isPresent()) {
            throw CliMessages.MESSAGES.exclusiveOptions("--channels", "--manifest");
        }
        if (this.manifestCoordinate.isPresent()) {
            ChannelManifestCoordinate manifest = ArtifactUtils.manifestCoordFromString((String)((String)this.manifestCoordinate.get()));
            this.checkFileExists(manifest.getUrl(), (String)this.manifestCoordinate.get());
        }
        if (!this.channelCoordinates.isEmpty()) {
            for (String coordStr : this.channelCoordinates) {
                ChannelCoordinate coord = ArtifactUtils.channelCoordFromString((String)coordStr);
                this.checkFileExists(coord.getUrl(), coordStr);
            }
        }
        if (this.featurePackOrDefinition.definition.isPresent()) {
            Path definition = this.featurePackOrDefinition.definition.get().toAbsolutePath();
            this.checkFileExists(definition.toUri().toURL(), definition.toString());
        }
        InstallCommand.verifyTargetDirectoryIsEmpty(this.directory);
        ProvisioningDefinition provisioningDefinition = this.buildDefinition();
        MavenOptions mavenOptions = this.getMavenOptions();
        ProvisioningConfig provisioningConfig = provisioningDefinition.toProvisioningConfig();
        List<Channel> channels = this.resolveChannels(provisioningDefinition, mavenOptions);
        List<Repository> shadowRepositories = RepositoryDefinition.from(this.shadowRepositories);
        ProvisioningAction provisioningAction = this.actionFactory.install(this.directory.toAbsolutePath(), mavenOptions, this.console);
        if (this.featurePackOrDefinition.fpl.isPresent()) {
            this.console.println(CliMessages.MESSAGES.installingFpl(this.featurePackOrDefinition.fpl.get()));
        } else if (this.featurePackOrDefinition.profile.isPresent()) {
            this.console.println(CliMessages.MESSAGES.installingProfile(this.featurePackOrDefinition.profile.get()));
        } else if (this.featurePackOrDefinition.definition.isPresent()) {
            this.console.println(CliMessages.MESSAGES.installingDefinition(this.featurePackOrDefinition.definition.get()));
        }
        List effectiveChannels = TemporaryRepositoriesHandler.overrideRepositories(channels, shadowRepositories);
        this.console.println(CliMessages.MESSAGES.usingChannels());
        ChannelPrinter channelPrinter = new ChannelPrinter(this.console);
        for (Channel channel : effectiveChannels) {
            channelPrinter.print(channel);
        }
        this.console.println("");
        List pendingLicenses = provisioningAction.getPendingLicenses(provisioningConfig, effectiveChannels);
        if (!pendingLicenses.isEmpty()) {
            new LicensePrinter().print(pendingLicenses);
            System.out.println();
            if (this.acceptAgreements) {
                System.out.println(CliMessages.MESSAGES.agreementSkipped("--accept-license-agreements"));
                System.out.println();
            } else if (!this.console.confirm(CliMessages.MESSAGES.acceptAgreements(), "", CliMessages.MESSAGES.installationCancelled())) {
                return 1;
            }
        }
        provisioningAction.provision(provisioningConfig, channels, shadowRepositories);
        this.console.println("");
        this.console.println(CliMessages.MESSAGES.installComplete(this.directory));
        float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
        return 0;
    }

    private void checkFileExists(URL resourceUrl, String argValue) throws ArgumentParsingException {
        if (resourceUrl != null) {
            try {
                InputStream is = resourceUrl.openStream();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw CliMessages.MESSAGES.missingRequiresResource(argValue);
            }
        }
    }

    private boolean isStandardFpl(String fpl) {
        return KnownFeaturePacks.isWellKnownName((String)fpl);
    }

    static class FeaturePackOrDefinition {
        @CommandLine.Option(names={"--profile"}, paramLabel="<installation-profile>", completionCandidates=FeaturePackCandidates.class, required=true, order=1)
        Optional<String> profile;
        @CommandLine.Option(names={"--fpl"}, paramLabel="<feature-pack-reference>", required=true, order=2)
        Optional<String> fpl;
        @CommandLine.Option(names={"--definition"}, paramLabel="<path>", required=true, order=3)
        Optional<Path> definition;

        FeaturePackOrDefinition() {
        }
    }
}

