/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.spi;

import java.nio.file.Path;
import java.util.Locale;
import org.wildfly.prospero.cli.DistributionInfo;
import org.wildfly.prospero.spi.internal.CliProvider;

public class CliProviderImpl
implements CliProvider {
    private boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");

    public String getScriptName() {
        String suffix = this.isWindows ? ".bat" : ".sh";
        return DistributionInfo.DIST_NAME + suffix;
    }

    public String getApplyUpdateCommand(Path installationPath, Path candidatePath) {
        return "update apply --dir " + this.escape(installationPath.toAbsolutePath()) + " --candidate-dir " + this.escape(candidatePath.toAbsolutePath()) + " --yes";
    }

    public String getApplyRevertCommand(Path installationPath, Path candidatePath) {
        return "revert apply --dir " + this.escape(installationPath.toAbsolutePath()) + " --candidate-dir " + this.escape(candidatePath.toAbsolutePath()) + " --yes";
    }

    private String escape(Path absolutePath) {
        return "\"" + absolutePath.toString() + "\"";
    }
}

