/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.api.exceptions.StreamNotFoundException;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonFeaturePackAnalyzer;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.licenses.License;
import org.wildfly.prospero.licenses.LicenseManager;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.metadata.ManifestVersionResolver;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class ProvisioningAction {
    private static final String CHANNEL_NAME_PREFIX = "channel-";
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;
    private final Console console;
    private final LicenseManager licenseManager;
    private final MavenOptions mvnOptions;

    public ProvisioningAction(Path installDir, MavenOptions mvnOptions, Console console) throws ProvisioningException {
        this.installDir = installDir;
        this.console = console;
        this.mvnOptions = mvnOptions;
        this.mavenSessionManager = new MavenSessionManager(mvnOptions);
        this.licenseManager = new LicenseManager();
        ProvisioningAction.verifyInstallDir(installDir);
    }

    public void provision(ProvisioningConfig provisioningConfig, List<Channel> channels) throws MalformedURLException, ProvisioningException, OperationException {
        this.provision(provisioningConfig, channels, Collections.emptyList());
    }

    public void provision(ProvisioningConfig provisioningConfig, List<Channel> channels, List<Repository> overwriteRepositories) throws ProvisioningException, OperationException, MalformedURLException {
        ProsperoLogger.ROOT_LOGGER.startingProvision(this.installDir);
        channels = this.enforceChannelNames(channels);
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug("Provisioning definition: " + provisioningConfig.toString());
            ProsperoLogger.ROOT_LOGGER.debug("Using channels: " + channels.stream().map(Channel::toString).collect(Collectors.joining(",")));
        }
        ArrayList<Channel> recordedChannels = new ArrayList<Channel>(channels);
        channels = TemporaryRepositoriesHandler.overrideRepositories(channels, overwriteRepositories);
        try (GalleonEnvironment galleonEnv = GalleonEnvironment.builder(this.installDir, channels, this.mavenSessionManager).setConsole(this.console).build();){
            ManifestVersionRecord manifestRecord;
            try {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug("Starting Galleon provisioning");
                }
                GalleonUtils.executeGalleon(options -> galleonEnv.getProvisioningManager().provision(provisioningConfig, (Map<String, String>)options), this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
            }
            catch (UnresolvedMavenArtifactException e) {
                throw new ArtifactResolutionException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), this.mavenSessionManager.isOffline());
            }
            try {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug("Resolving installed manifest versions");
                }
                manifestRecord = new ManifestVersionResolver(this.mavenSessionManager.getProvisioningRepo(), this.mavenSessionManager.newRepositorySystem()).getCurrentVersions(channels);
            }
            catch (IOException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToDownloadFile(e);
            }
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.debug("Recording installed metadata");
            }
            this.writeProsperoMetadata(this.installDir, galleonEnv.getRepositoryManager(), recordedChannels, manifestRecord);
        }
        try {
            GalleonFeaturePackAnalyzer galleonFeaturePackAnalyzer = new GalleonFeaturePackAnalyzer(channels, this.mavenSessionManager);
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.debug("Recording accepted licenses");
            }
            try {
                this.licenseManager.recordAgreements(this.getPendingLicenses(provisioningConfig, galleonFeaturePackAnalyzer), this.installDir);
            }
            catch (IOException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToWriteFile(this.installDir.resolve("licenses"), e);
            }
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.debug("Updating galleon cache");
            }
            galleonFeaturePackAnalyzer.cacheGalleonArtifacts(this.installDir, provisioningConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ProsperoLogger.ROOT_LOGGER.provisioningComplete(this.installDir);
    }

    public List<License> getPendingLicenses(ProvisioningConfig provisioningConfig, List<Channel> channels) throws OperationException {
        Objects.requireNonNull(provisioningConfig);
        Objects.requireNonNull(channels);
        GalleonFeaturePackAnalyzer exporter = new GalleonFeaturePackAnalyzer(channels, this.mavenSessionManager);
        return this.getPendingLicenses(provisioningConfig, exporter);
    }

    private List<License> getPendingLicenses(ProvisioningConfig provisioningConfig, GalleonFeaturePackAnalyzer exporter) throws OperationException {
        try {
            List<String> featurePacks = exporter.getFeaturePacks(provisioningConfig);
            return this.licenseManager.getLicenses(featurePacks);
        }
        catch (MavenUniverseException e) {
            if (e.getCause() instanceof org.eclipse.aether.resolution.ArtifactResolutionException) {
                throw this.wrapAetherException((org.eclipse.aether.resolution.ArtifactResolutionException)e.getCause());
            }
            if (e.getCause() instanceof UnresolvedMavenArtifactException && e.getMessage().contains("(no stream found)")) {
                UnresolvedMavenArtifactException cause = (UnresolvedMavenArtifactException)e.getCause();
                throw new StreamNotFoundException(ProsperoLogger.ROOT_LOGGER.streamNotFound(), e, cause.getUnresolvedArtifacts(), cause.getAttemptedRepositories(), this.mavenSessionManager.isOffline());
            }
            throw new ArtifactResolutionException(e.getMessage(), e);
        }
        catch (IOException | ProvisioningException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeProsperoMetadata(Path home, ChannelMavenArtifactRepositoryManager maven, List<Channel> channels, ManifestVersionRecord manifestVersions) throws MetadataException {
        ChannelManifest manifest = maven.resolvedChannel();
        try (InstallationMetadata installationMetadata = InstallationMetadata.newInstallation(home, manifest, new ProsperoConfig(channels, this.mvnOptions), Optional.of(manifestVersions));){
            installationMetadata.recordProvision(true, true);
        }
    }

    private List<Channel> enforceChannelNames(List<Channel> newChannels) {
        AtomicInteger channelCounter = new AtomicInteger(0);
        return newChannels.stream().map(c -> {
            if (StringUtils.isEmpty(c.getName())) {
                return new Channel(c.getSchemaVersion(), CHANNEL_NAME_PREFIX + channelCounter.getAndIncrement(), c.getDescription(), c.getVendor(), c.getRepositories(), c.getManifestCoordinate(), c.getBlocklistCoordinate(), c.getNoStreamStrategy());
            }
            return c;
        }).collect(Collectors.toList());
    }

    private static void verifyInstallDir(Path directory) {
        if (directory.toFile().isFile()) {
            throw ProsperoLogger.ROOT_LOGGER.dirMustBeDirectory(directory);
        }
        if (!ProvisioningAction.isEmptyDirectory(directory)) {
            throw ProsperoLogger.ROOT_LOGGER.cannotInstallIntoNonEmptyDirectory(directory);
        }
    }

    private static boolean isEmptyDirectory(Path directory) {
        String[] list = directory.toFile().list();
        return list == null || list.length == 0;
    }

    private ArtifactResolutionException wrapAetherException(org.eclipse.aether.resolution.ArtifactResolutionException e) throws ArtifactResolutionException {
        List<ArtifactResult> results = e.getResults();
        Set<ArtifactCoordinate> missingArtifacts = results.stream().filter(r -> !r.isResolved()).map(r -> r.getArtifact()).map(a -> new ArtifactCoordinate(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier(), a.getVersion())).collect(Collectors.toSet());
        Set<Repository> repositories = results.stream().filter(r -> !r.isResolved()).flatMap(r -> r.getRequest().getRepositories().stream()).map(RepositoryUtils::toChannelRepository).collect(Collectors.toSet());
        return new ArtifactResolutionException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, missingArtifacts, repositories, this.mavenSessionManager.isOffline());
    }
}

