/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Diff {
    private Optional<String> name;
    private Optional<String> oldValue;
    private Optional<String> newValue;
    private List<Diff> children;
    private final Status status;

    public Optional<String> getName() {
        return this.name;
    }

    public List<Diff> getChildren() {
        return this.children;
    }

    public Optional<String> getOldValue() {
        return this.oldValue;
    }

    public Optional<String> getNewValue() {
        return this.newValue;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Diff> getChild(String name) {
        return this.children.stream().filter(c -> c.getName().orElse("").equals(name)).findFirst();
    }

    public Diff(String name, String oldValue, String newValue) {
        this.name = Optional.ofNullable(name);
        this.oldValue = Optional.ofNullable(oldValue);
        this.newValue = Optional.ofNullable(newValue);
        this.children = Collections.emptyList();
        this.status = this.oldValue.isEmpty() ? Status.ADDED : (this.newValue.isEmpty() ? Status.REMOVED : Status.MODIFIED);
    }

    public Diff(String name, Status status, Diff ... nested) {
        this(name, status, List.of(nested));
    }

    public Diff(String name, Status status, List<Diff> nested) {
        this.name = Optional.ofNullable(name);
        this.status = status;
        this.oldValue = Optional.empty();
        this.newValue = Optional.empty();
        this.children = nested;
    }

    public String toString() {
        return "Diff{name=" + this.name + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", children=" + this.children + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Diff diff = (Diff)o;
        return Objects.equals(this.name, diff.name) && Objects.equals(this.oldValue, diff.oldValue) && Objects.equals(this.newValue, diff.newValue) && Objects.equals(this.children, diff.children) && this.status == diff.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.oldValue, this.newValue, this.children, this.status});
    }

    public static enum Status {
        ADDED,
        REMOVED,
        MODIFIED;

    }
}

