/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.printers;

import org.wildfly.channel.Channel;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.api.Console;

public class ChannelPrinter {
    private final Console console;

    public ChannelPrinter(Console console) {
        this.console = console;
    }

    public void print(Channel channel) {
        String startMarker = "# ";
        if (channel.getName() != null && !channel.getName().isEmpty()) {
            this.console.println(startMarker + channel.getName());
            startMarker = "  ";
        }
        String manifest = channel.getManifestCoordinate().getMaven() == null ? channel.getManifestCoordinate().getUrl().toExternalForm() : ChannelPrinter.toGav(channel.getManifestCoordinate().getMaven());
        this.console.println(startMarker + "manifest: " + manifest);
        this.console.println("  repositories:");
        for (Repository repository : channel.getRepositories()) {
            this.console.println("    id: " + repository.getId());
            this.console.println("    url: " + repository.getUrl());
        }
    }

    private static String toGav(MavenCoordinate coord) {
        String ga = coord.getGroupId() + ":" + coord.getArtifactId();
        if (coord.getVersion() != null && !coord.getVersion().isEmpty()) {
            return ga + ":" + coord.getVersion();
        }
        return ga;
    }
}

